/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import com.datastax.driver.core.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.keyspace.AddColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.ColumnChangeSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.RenameColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.UserTypeNameSpecification;

public class AlterUserTypeSpecification
extends UserTypeNameSpecification {
    private final List<ColumnChangeSpecification> changes = new ArrayList<ColumnChangeSpecification>();

    private AlterUserTypeSpecification(CqlIdentifier name) {
        super(name);
    }

    public static AlterUserTypeSpecification alterType(String typeName) {
        return AlterUserTypeSpecification.alterType(CqlIdentifier.of(typeName));
    }

    private static AlterUserTypeSpecification alterType(CqlIdentifier typeName) {
        return new AlterUserTypeSpecification(typeName);
    }

    public AlterUserTypeSpecification add(String field, DataType type) {
        return this.add(CqlIdentifier.of(field), type);
    }

    public AlterUserTypeSpecification add(CqlIdentifier field, DataType type) {
        return this.add(AddColumnSpecification.addColumn(field, type));
    }

    public AlterUserTypeSpecification alter(String field, DataType type) {
        return this.alter(CqlIdentifier.of(field), type);
    }

    public AlterUserTypeSpecification alter(CqlIdentifier field, DataType type) {
        return this.add(AlterColumnSpecification.alterColumn(field, type));
    }

    public AlterUserTypeSpecification rename(String from, String to) {
        return this.rename(CqlIdentifier.of(from), CqlIdentifier.of(to));
    }

    public AlterUserTypeSpecification rename(CqlIdentifier from, CqlIdentifier to) {
        return this.add(new RenameColumnSpecification(from, to));
    }

    private AlterUserTypeSpecification add(ColumnChangeSpecification specification) {
        this.changes.add(specification);
        return this;
    }

    public List<ColumnChangeSpecification> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }
}

