/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.Row;
import org.springframework.data.cassandra.core.convert.CassandraRowValueProvider;
import org.springframework.data.cassandra.core.convert.ColumnReader;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BasicCassandraRowValueProvider
implements CassandraRowValueProvider {
    private final ColumnReader reader;
    private final SpELExpressionEvaluator evaluator;

    public BasicCassandraRowValueProvider(Row source, DefaultSpELExpressionEvaluator evaluator) {
        Assert.notNull((Object)source, (String)"Source Row must not be null");
        Assert.notNull((Object)evaluator, (String)"DefaultSpELExpressionEvaluator must not be null");
        this.reader = new ColumnReader(source);
        this.evaluator = evaluator;
    }

    @Nullable
    public <T> T getPropertyValue(CassandraPersistentProperty property) {
        String spelExpression = property.getSpelExpression();
        if (spelExpression != null) {
            return (T)this.evaluator.evaluate(spelExpression);
        }
        return (T)this.reader.get(property.getColumnName());
    }

    @Override
    public Row getRow() {
        return this.reader.getRow();
    }

    @Override
    public boolean hasProperty(CassandraPersistentProperty property) {
        Assert.notNull((Object)property, (String)"CassandraPersistentProperty must not be null");
        return this.getRow().getColumnDefinitions().contains(property.getColumnName().toCql());
    }
}

