/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public class WriteResult {
    private final boolean wasApplied;
    private final List<ExecutionInfo> executionInfo;
    private final List<Row> rows;

    WriteResult(List<ExecutionInfo> executionInfo, boolean wasApplied, List<Row> rows) {
        this.executionInfo = executionInfo;
        this.wasApplied = wasApplied;
        this.rows = rows;
    }

    private WriteResult(ResultSet resultSet) {
        this.executionInfo = resultSet.getAllExecutionInfo();
        this.wasApplied = resultSet.wasApplied();
        int limit = resultSet.getAvailableWithoutFetching();
        ArrayList<Row> rows = new ArrayList<Row>(limit);
        for (int count = 0; count < limit; ++count) {
            rows.add(resultSet.one());
        }
        this.rows = Collections.unmodifiableList(rows);
    }

    public static WriteResult of(ResultSet resultSet) {
        Assert.notNull((Object)resultSet, (String)"ResultSet must not be null");
        return new WriteResult(resultSet);
    }

    public boolean wasApplied() {
        return this.wasApplied;
    }

    public List<ExecutionInfo> getExecutionInfo() {
        return this.executionInfo;
    }

    public List<Row> getRows() {
        return this.rows;
    }
}

