/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.UserType;
import java.util.Comparator;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentPropertyComparator;
import org.springframework.data.cassandra.core.mapping.CompositeCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.data.cassandra.core.mapping.UnsupportedCassandraOperationException;
import org.springframework.data.cassandra.util.SpelUtils;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicCassandraPersistentEntity<T>
extends BasicPersistentEntity<T, CassandraPersistentProperty>
implements CassandraPersistentEntity<T>,
ApplicationContextAware {
    private static final CassandraPersistentEntityMetadataVerifier DEFAULT_VERIFIER = new CompositeCassandraPersistentEntityMetadataVerifier();
    private CassandraPersistentEntityMetadataVerifier verifier = DEFAULT_VERIFIER;
    @Nullable
    private StandardEvaluationContext spelContext;
    private Optional<Boolean> forceQuote = Optional.empty();
    private Optional<CqlIdentifier> tableName = Optional.empty();

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation) {
        this(typeInformation, DEFAULT_VERIFIER);
    }

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation, CassandraPersistentEntityMetadataVerifier verifier) {
        super(typeInformation, (Comparator)CassandraPersistentPropertyComparator.INSTANCE);
        this.setVerifier(verifier);
    }

    protected CqlIdentifier determineTableName() {
        Table annotation = (Table)this.findAnnotation(Table.class);
        if (annotation != null) {
            return this.determineName(annotation.value(), annotation.forceQuote());
        }
        return CqlIdentifier.of(this.getType().getSimpleName(), false);
    }

    CqlIdentifier determineName(String value, boolean forceQuote) {
        if (!StringUtils.hasText((String)value)) {
            return CqlIdentifier.of(this.getType().getSimpleName(), forceQuote);
        }
        String name = this.spelContext == null ? value : SpelUtils.evaluate(value, (EvaluationContext)this.spelContext);
        Assert.state((name != null ? 1 : 0) != 0, () -> String.format("Cannot determine default name for %s", this));
        return CqlIdentifier.of(name, forceQuote);
    }

    public void addAssociation(Association<CassandraPersistentProperty> association) {
        throw new UnsupportedCassandraOperationException("Cassandra does not support associations");
    }

    public void doWithAssociations(AssociationHandler<CassandraPersistentProperty> handler) {
        throw new UnsupportedCassandraOperationException("Cassandra does not support associations");
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return this.isAnnotationPresent(PrimaryKeyClass.class);
    }

    public void verify() throws MappingException {
        super.verify();
        this.verifier.verify(this);
        if (!this.tableName.isPresent()) {
            this.setTableName(this.determineTableName());
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        this.spelContext = new StandardEvaluationContext();
        this.spelContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.spelContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context));
        this.spelContext.setRootObject((Object)context);
    }

    @Override
    public void setForceQuote(boolean forceQuote) {
        boolean changed = !this.forceQuote.isPresent() || this.forceQuote.filter(v -> v != forceQuote).isPresent();
        this.forceQuote = Optional.of(forceQuote);
        if (changed) {
            this.setTableName(CqlIdentifier.of(this.getTableName().getUnquoted(), forceQuote));
        }
    }

    @Override
    public void setTableName(CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"CqlIdentifier must not be null");
        this.tableName = Optional.of(tableName);
    }

    @Override
    public CqlIdentifier getTableName() {
        return this.tableName.orElseGet(this::determineTableName);
    }

    public void setVerifier(CassandraPersistentEntityMetadataVerifier verifier) {
        this.verifier = verifier;
    }

    public CassandraPersistentEntityMetadataVerifier getVerifier() {
        return this.verifier;
    }

    @Override
    public boolean isUserDefinedType() {
        return false;
    }

    @Override
    @Nullable
    public UserType getUserType() {
        return null;
    }
}

