/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.generator;

import org.springframework.data.cassandra.core.cql.generator.AddColumnCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.AlterColumnCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.ColumnChangeCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.RenameColumnCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.UserTypeNameCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.AddColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterUserTypeSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.ColumnChangeSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.RenameColumnSpecification;
import org.springframework.util.Assert;

public class AlterUserTypeCqlGenerator
extends UserTypeNameCqlGenerator<AlterUserTypeSpecification> {
    public AlterUserTypeCqlGenerator(AlterUserTypeSpecification specification) {
        super(specification);
    }

    public static String toCql(AlterUserTypeSpecification specification) {
        return new AlterUserTypeCqlGenerator(specification).toCql();
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        Assert.notNull((Object)((AlterUserTypeSpecification)this.getSpecification()).getName(), (String)"User type name must not be null");
        Assert.isTrue((!((AlterUserTypeSpecification)this.getSpecification()).getChanges().isEmpty() ? 1 : 0) != 0, (String)String.format("User type [%s] does not contain fields", ((AlterUserTypeSpecification)this.getSpecification()).getName()));
        return this.changesCql(this.preambleCql(cql)).append(";");
    }

    private StringBuilder preambleCql(StringBuilder cql) {
        return cql.append("ALTER TYPE ").append(((AlterUserTypeSpecification)this.spec()).getName()).append(' ');
    }

    private StringBuilder changesCql(StringBuilder cql) {
        boolean first = true;
        boolean lastChangeWasRename = false;
        for (ColumnChangeSpecification change : ((AlterUserTypeSpecification)this.spec()).getChanges()) {
            if (!first) {
                cql.append(' ');
            }
            this.getCqlGeneratorFor(change, lastChangeWasRename).toCql(cql);
            lastChangeWasRename = change instanceof RenameColumnSpecification;
            first = false;
        }
        return cql;
    }

    private ColumnChangeCqlGenerator<?> getCqlGeneratorFor(ColumnChangeSpecification change, boolean lastChangeWasRename) {
        if (change instanceof AddColumnSpecification) {
            return new AddColumnCqlGenerator((AddColumnSpecification)change);
        }
        if (change instanceof AlterColumnSpecification) {
            return new AlterColumnCqlGenerator((AlterColumnSpecification)change);
        }
        if (change instanceof RenameColumnSpecification) {
            return new RenameColumnCqlGenerator(lastChangeWasRename ? "AND" : "RENAME", change);
        }
        throw new IllegalArgumentException(String.format("Unknown ColumnChangeSpecification type: %s", change.getClass().getName()));
    }
}

