/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.exceptions.DriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.ReactiveSessionFactory;
import org.springframework.data.cassandra.core.cql.CassandraExceptionTranslator;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class ReactiveCassandraAccessor
implements InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CqlExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();
    @Nullable
    private ReactiveSessionFactory sessionFactory;

    public void setSessionFactory(ReactiveSessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"ReactiveSessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    @Nullable
    public ReactiveSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setExceptionTranslator(CqlExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)exceptionTranslator, (String)"CQLExceptionTranslator must not be null");
        this.exceptionTranslator = exceptionTranslator;
    }

    public CqlExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.sessionFactory, (String)"ReactiveSessionFactory must not be null");
    }

    @Nullable
    protected DataAccessException translateExceptionIfPossible(DriverException ex) {
        Assert.notNull((Object)ex, (String)"DriverException must not be null");
        return this.getExceptionTranslator().translateExceptionIfPossible((RuntimeException)ex);
    }

    protected DataAccessException translate(String task, @Nullable String cql, DriverException ex) {
        Assert.notNull((Object)ex, (String)"DriverException must not be null");
        return this.getExceptionTranslator().translate(task, cql, ex);
    }
}

