/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.Row;
import org.springframework.cassandra.core.RowCallback;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.util.Assert;

public class CassandraConverterRowCallback<T>
implements RowCallback<T> {
    private final CassandraConverter reader;
    private final Class<T> type;

    public CassandraConverterRowCallback(CassandraConverter reader, Class<T> type) {
        Assert.notNull((Object)reader, (String)"CassandraConverter must not be null");
        Assert.notNull(type, (String)"Target class must not be null");
        this.reader = reader;
        this.type = type;
    }

    public T doWith(Row row) {
        return (T)this.reader.read(this.type, row);
    }
}

