/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.util.Assert;

public class BasicMapId
implements MapId {
    protected Map<String, Serializable> map = new HashMap<String, Serializable>();

    public static MapId id() {
        return new BasicMapId();
    }

    public static MapId id(String name, Serializable value) {
        return new BasicMapId().with(name, value);
    }

    public static MapId id(MapId id) {
        return new BasicMapId(id);
    }

    public BasicMapId() {
    }

    public BasicMapId(Map<String, Serializable> map) {
        Assert.notNull(map, (String)"Map must not be null");
        this.map.putAll(map);
    }

    @Override
    public BasicMapId with(String name, Serializable value) {
        this.put(name, value);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object name) {
        return this.map.containsKey(name);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Serializable>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof Map)) {
            return false;
        }
        return this.map.equals(that);
    }

    @Override
    public Serializable get(Object name) {
        return this.map.get(name);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Serializable put(String name, Serializable value) {
        return this.map.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Serializable> source) {
        this.map.putAll(source);
    }

    @Override
    public Serializable remove(Object name) {
        return this.map.remove(name);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Serializable> values() {
        return this.map.values();
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{ ");
        boolean first = true;
        for (Map.Entry<String, Serializable> entry : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(entry.getKey()).append(" : ").append(entry.getValue());
        }
        return s.append(" }").toString();
    }
}

