/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cassandra.config.xml.CassandraCqlTemplateParser;
import org.springframework.data.cassandra.config.CassandraTemplateFactoryBean;
import org.springframework.data.cassandra.config.xml.CassandraMappingXmlBeanFactoryPostProcessorRegistrar;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CassandraTemplateParser
extends CassandraCqlTemplateParser {
    protected Class<?> getBeanClass(Element element) {
        return CassandraTemplateFactoryBean.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraTemplate";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        CassandraMappingXmlBeanFactoryPostProcessorRegistrar.ensureRegistration(element, parserContext);
        super.doParse(element, parserContext, builder);
        this.parseConverterAttribute(element, parserContext, builder);
    }

    protected void parseConverterAttribute(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String converterRef = element.getAttribute("cassandra-converter-ref");
        if (!StringUtils.hasText((String)converterRef)) {
            converterRef = "cassandraConverter";
        }
        builder.addPropertyReference("converter", converterRef);
    }
}

