/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.StringBasedCassandraQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class ExpressionEvaluatingParameterBinder {
    private final SpelExpressionParser expressionParser;
    private final EvaluationContextProvider evaluationContextProvider;

    public ExpressionEvaluatingParameterBinder(SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)expressionParser, (String)"ExpressionParser must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null");
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public List<Object> bind(CassandraParameterAccessor parameterAccessor, BindingContext bindingContext) {
        if (!bindingContext.hasBindings()) {
            return Collections.emptyList();
        }
        ArrayList<Object> parameters = new ArrayList<Object>(bindingContext.getBindings().size());
        for (StringBasedCassandraQuery.ParameterBinding binding : bindingContext.getBindings()) {
            parameters.add(this.getParameterValueForBinding(parameterAccessor, bindingContext.getParameters(), binding));
        }
        return parameters;
    }

    private Object getParameterValueForBinding(CassandraParameterAccessor parameterAccessor, CassandraParameters parameters, StringBasedCassandraQuery.ParameterBinding binding) {
        if (binding.isExpression()) {
            return this.evaluateExpression(binding.getExpression(), parameters, parameterAccessor.getValues());
        }
        return binding.isNamed() ? parameterAccessor.getBindableValue(this.getParameterIndex(parameters, binding.getParameterName())) : parameterAccessor.getBindableValue(binding.getParameterIndex());
    }

    private int getParameterIndex(CassandraParameters parameters, String parameterName) {
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            CassandraParameters.CassandraParameter parameter = (CassandraParameters.CassandraParameter)((Object)iterator.next());
            if (!parameterName.equals(parameter.getName())) continue;
            return parameter.getIndex();
        }
        throw new IllegalArgumentException(String.format("Invalid parameter name; Cannot resolve parameter [%s]", parameterName));
    }

    private Object evaluateExpression(String expressionString, CassandraParameters parameters, Object[] parameterValues) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext((Parameters)parameters, parameterValues);
        Expression expression = this.expressionParser.parseExpression(expressionString);
        return expression.getValue(evaluationContext, Object.class);
    }

    static class BindingContext {
        final CassandraQueryMethod queryMethod;
        final List<StringBasedCassandraQuery.ParameterBinding> bindings;

        public BindingContext(CassandraQueryMethod queryMethod, List<StringBasedCassandraQuery.ParameterBinding> bindings) {
            this.queryMethod = queryMethod;
            this.bindings = bindings;
        }

        boolean hasBindings() {
            return !CollectionUtils.isEmpty(this.bindings);
        }

        public List<StringBasedCassandraQuery.ParameterBinding> getBindings() {
            return Collections.unmodifiableList(this.bindings);
        }

        public CassandraParameters getParameters() {
            return this.queryMethod.getParameters();
        }

        public CassandraQueryMethod getQueryMethod() {
            return this.queryMethod;
        }
    }
}

