/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.util.Assert;

class DtoInstantiatingConverter
implements Converter<Object, Object> {
    private final Class<?> targetType;
    private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context;
    private final EntityInstantiator instantiator;

    DtoInstantiatingConverter(Class<?> dtoType, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> context, EntityInstantiators instantiator) {
        Assert.notNull(dtoType, (String)"DTO type must not be null!");
        Assert.notNull(context, (String)"MappingContext must not be null!");
        Assert.notNull((Object)instantiator, (String)"EntityInstantiators must not be null!");
        this.targetType = dtoType;
        this.context = context;
        this.instantiator = instantiator.getInstantiatorFor(context.getPersistentEntity(dtoType));
    }

    public Object convert(Object source) {
        if (this.targetType.isInterface()) {
            return source;
        }
        final PersistentEntity sourceEntity = this.context.getPersistentEntity(source.getClass());
        final PersistentPropertyAccessor sourceAccessor = sourceEntity.getPropertyAccessor(source);
        PersistentEntity targetEntity = this.context.getPersistentEntity(this.targetType);
        Object dto = this.instantiator.createInstance(targetEntity, new ParameterValueProvider(){

            public Object getParameterValue(PreferredConstructor.Parameter parameter) {
                return sourceAccessor.getProperty(sourceEntity.getPersistentProperty(parameter.getName()));
            }
        });
        final PersistentPropertyAccessor targetAccessor = targetEntity.getPropertyAccessor(dto);
        final PreferredConstructor constructor = targetEntity.getPersistenceConstructor();
        targetEntity.doWithProperties(new SimplePropertyHandler(){

            public void doWithPersistentProperty(PersistentProperty<?> property) {
                if (constructor.isConstructorParameter(property)) {
                    return;
                }
                targetAccessor.setProperty(property, sourceAccessor.getProperty(sourceEntity.getPersistentProperty(property.getName())));
            }
        });
        return dto;
    }
}

