/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.cassandra.core.AsynchronousQueryListener;
import org.springframework.cassandra.core.Cancellable;
import org.springframework.cassandra.core.CqlTemplate;
import org.springframework.cassandra.core.QueryForObjectListener;
import org.springframework.cassandra.core.QueryOptions;
import org.springframework.cassandra.core.RowCallback;
import org.springframework.cassandra.core.WriteOptions;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.support.EmptyResultSet;
import org.springframework.cassandra.core.util.CollectionUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.CassandraBatchOperations;
import org.springframework.data.cassandra.core.CassandraBatchTemplate;
import org.springframework.data.cassandra.core.CassandraConverterRowCallback;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.DeletionListener;
import org.springframework.data.cassandra.core.WriteListener;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

public class CassandraTemplate
extends CqlTemplate
implements CassandraOperations {
    protected CassandraConverter cassandraConverter;
    protected CassandraMappingContext mappingContext;

    public CassandraTemplate() {
    }

    public CassandraTemplate(Session session) {
        this(session, null);
    }

    public CassandraTemplate(Session session, CassandraConverter converter) {
        this.setSession(session);
        this.setConverter(CassandraTemplate.resolveConverter(converter));
    }

    private static CassandraConverter resolveConverter(CassandraConverter cassandraConverter) {
        return cassandraConverter != null ? cassandraConverter : CassandraTemplate.getDefaultCassandraConverter();
    }

    private static CassandraConverter getDefaultCassandraConverter() {
        MappingCassandraConverter mappingCassandraConverter = new MappingCassandraConverter();
        mappingCassandraConverter.afterPropertiesSet();
        return mappingCassandraConverter;
    }

    public void setConverter(CassandraConverter cassandraConverter) {
        Assert.notNull((Object)cassandraConverter, (String)"CassandraConverter must not be null");
        this.cassandraConverter = cassandraConverter;
        this.mappingContext = cassandraConverter.getMappingContext();
    }

    @Override
    public CassandraConverter getConverter() {
        return this.cassandraConverter;
    }

    @Deprecated
    public CassandraMappingContext getCassandraMappingContext() {
        return this.mappingContext;
    }

    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.cassandraConverter, (String)"CassandraConverter must not be null");
        Assert.notNull((Object)this.mappingContext, (String)"CassandraMappingContext must not be null");
    }

    @Override
    public boolean exists(Class<?> entityClass, Object id) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        Assert.notNull((Object)id, (String)"Id must not be null");
        CassandraPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        Select select = QueryBuilder.select().countAll().from(entity.getTableName().toCql());
        this.cassandraConverter.write(id, select.where(), entity);
        Long count = (Long)this.queryForObject(select, Long.class);
        return count != 0L;
    }

    @Override
    public long count(Class<?> type) {
        return this.count(this.getTableName(type).toCql());
    }

    @Override
    public <T> void delete(List<T> entities) {
        this.delete((T)entities, null);
    }

    @Override
    public <T> void delete(List<T> entities, QueryOptions options) {
        this.doBatchDelete(entities, options);
    }

    @Override
    public void deleteById(Class<?> entityClass, Object id) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        Assert.notNull((Object)id, (String)"Id must not be null");
        CassandraPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        Delete delete = QueryBuilder.delete().from(entity.getTableName().toCql());
        this.cassandraConverter.write(id, delete.where(), entity);
        this.execute(delete);
    }

    @Override
    public <T> void delete(T entity) {
        this.delete(entity, null);
    }

    @Override
    public <T> void delete(T entity, QueryOptions options) {
        this.doDelete(entity, options);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(List<T> entities) {
        return this.doBatchDeleteAsync(entities, null, null);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(List<T> entities, QueryOptions options) {
        return this.doBatchDeleteAsync(entities, null, options);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(List<T> entities, DeletionListener<T> listener) {
        return this.doBatchDeleteAsync(entities, listener, null);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(List<T> entities, DeletionListener<T> listener, QueryOptions options) {
        return this.doBatchDeleteAsync(entities, listener, options);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(T entity) {
        return this.doDeleteAsync(entity, null, null);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(T entity, QueryOptions options) {
        return this.doDeleteAsync(entity, null, options);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(T entity, DeletionListener<T> listener) {
        return this.doDeleteAsync(entity, listener, null);
    }

    @Override
    public <T> Cancellable deleteAsynchronously(T entity, DeletionListener<T> listener, QueryOptions options) {
        return this.doDeleteAsync(entity, listener, options);
    }

    @Override
    public CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getPersistentEntity(entityClass).getTableName();
    }

    @Override
    public <T> List<T> insert(List<T> entities) {
        return this.insert((T)entities, null);
    }

    @Override
    public <T> List<T> insert(List<T> entities, WriteOptions options) {
        return this.doBatchInsert(entities, options);
    }

    @Override
    public <T> T insert(T entity) {
        return this.insert(entity, null);
    }

    @Override
    public <T> T insert(T entity, WriteOptions options) {
        return this.doInsert(entity, options);
    }

    @Override
    @Deprecated
    public <T> List<T> insertAsynchronously(List<T> entities) {
        this.doInsertAsynchronously(entities, null, null);
        return entities;
    }

    @Override
    @Deprecated
    public <T> List<T> insertAsynchronously(List<T> entities, WriteOptions options) {
        this.doInsertAsynchronously(entities, null, options);
        return entities;
    }

    @Override
    public <T> Cancellable insertAsynchronously(List<T> entities, WriteListener<T> listener) {
        return this.doInsertAsynchronously(entities, listener, null);
    }

    @Override
    public <T> Cancellable insertAsynchronously(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doInsertAsynchronously(entities, listener, options);
    }

    protected <T> Cancellable doInsertAsynchronously(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doBatchInsertAsync(entities, listener, options);
    }

    @Override
    @Deprecated
    public <T> T insertAsynchronously(T entity) {
        this.insertAsynchronously(entity, null, null);
        return entity;
    }

    @Override
    @Deprecated
    public <T> T insertAsynchronously(T entity, WriteOptions options) {
        this.insertAsynchronously(entity, null, options);
        return entity;
    }

    @Override
    public <T> Cancellable insertAsynchronously(T entity, WriteListener<T> listener) {
        return this.insertAsynchronously(entity, listener, null);
    }

    @Override
    public <T> Cancellable insertAsynchronously(T entity, WriteListener<T> listener, WriteOptions options) {
        return this.doInsertAsync(entity, listener, options);
    }

    @Override
    public <T> List<T> selectAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.select(QueryBuilder.select().all().from(this.getTableName(entityClass).toCql()), entityClass);
    }

    @Override
    public <T> List<T> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.select(cql, new CassandraConverterRowCallback<T>(this.cassandraConverter, entityClass));
    }

    @Override
    public <T> List<T> select(Select select, Class<T> entityClass) {
        Assert.notNull((Object)select, (String)"Select must not be null");
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.select(select, new CassandraConverterRowCallback<T>(this.cassandraConverter, entityClass));
    }

    @Override
    public <T> List<T> selectBySimpleIds(Class<T> entityClass, Iterable<?> ids) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        Assert.notNull(ids, (String)"Ids must not be null");
        CassandraPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        if (entity.getIdProperty() == null || ((CassandraPersistentProperty)entity.getIdProperty()).isCompositePrimaryKey()) {
            String typeName = entity.getIdProperty() == null ? "Unknown" : ((CassandraPersistentProperty)entity.getIdProperty()).getCompositePrimaryKeyEntity().getType().getName();
            throw new IllegalArgumentException(String.format("Entity class [%s] uses a composite primary key class [%s] which this method can't support", entityClass.getName(), typeName));
        }
        Select select = QueryBuilder.select().all().from(entity.getTableName().toCql());
        select.where(QueryBuilder.in((String)((CassandraPersistentProperty)entity.getIdProperty()).getColumnName().toCql(), (Object[])CollectionUtils.toArray(ids)));
        return this.select(select, entityClass);
    }

    @Override
    public <T> T selectOneById(Class<T> entityClass, Object id) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        Assert.notNull((Object)id, (String)"Id must not be null");
        CassandraPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        Select select = QueryBuilder.select().all().from(entity.getTableName().toCql());
        this.cassandraConverter.write(id, select.where(), entity);
        return this.selectOne(select, entityClass);
    }

    @Deprecated
    protected void appendIdCriteria(ClauseCallback clauseCallback, CassandraPersistentEntity<?> entity, Map<?, ?> id) {
        for (Map.Entry<?, ?> entry : id.entrySet()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)entity.getPersistentProperty(entry.getKey().toString());
            if (property == null) {
                throw new IllegalArgumentException(String.format("Entity class [%s] has no persistent property named [%s]", entity.getType().getName(), entry.getKey()));
            }
            clauseCallback.doWithClause(QueryBuilder.eq((String)property.getColumnName().toCql(), entry.getValue()));
        }
    }

    @Deprecated
    protected void appendIdCriteria(final ClauseCallback clauseCallback, CassandraPersistentEntity<?> entity, Object id) {
        if (id instanceof Map) {
            this.appendIdCriteria(clauseCallback, entity, (Map)id);
            return;
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty.isCompositePrimaryKey()) {
            CassandraPersistentEntity<?> idEntity = idProperty.getCompositePrimaryKeyEntity();
            PersistentPropertyAccessor idAccessor = idEntity.getPropertyAccessor(id);
            final ConvertingPropertyAccessor covertingIdAccessor = new ConvertingPropertyAccessor(idAccessor, this.cassandraConverter.getConversionService());
            idEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

                public void doWithPersistentProperty(CassandraPersistentProperty property) {
                    clauseCallback.doWithClause(QueryBuilder.eq((String)property.getColumnName().toCql(), (Object)covertingIdAccessor.getProperty((PersistentProperty)property, property.getActualType())));
                }
            });
            return;
        }
        clauseCallback.doWithClause(QueryBuilder.eq((String)idProperty.getColumnName().toCql(), (Object)id));
    }

    @Deprecated
    protected void appendIdCriteria(final Select.Where where, CassandraPersistentEntity<?> entity, Object id) {
        this.appendIdCriteria(new ClauseCallback(){

            @Override
            public void doWithClause(Clause clause) {
                where.and(clause);
            }
        }, entity, id);
    }

    @Deprecated
    protected void appendIdCriteria(final Delete.Where where, CassandraPersistentEntity<?> entity, Object id) {
        this.appendIdCriteria(new ClauseCallback(){

            @Override
            public void doWithClause(Clause clause) {
                where.and(clause);
            }
        }, entity, id);
    }

    @Override
    public <T> T selectOne(String cql, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.selectOne(cql, new CassandraConverterRowCallback<T>(this.cassandraConverter, entityClass));
    }

    @Override
    public <T> T selectOne(Select select, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.selectOne(select, new CassandraConverterRowCallback<T>(this.cassandraConverter, entityClass));
    }

    @Override
    public <T> List<T> update(List<T> entities) {
        return this.update((T)entities, null);
    }

    @Override
    public <T> List<T> update(List<T> entities, WriteOptions options) {
        return this.doBatchUpdate(entities, options);
    }

    @Override
    public <T> T update(T entity) {
        return this.update(entity, null);
    }

    @Override
    public <T> T update(T entity, WriteOptions options) {
        return this.doUpdate(entity, options);
    }

    @Override
    public <T> List<T> updateAsynchronously(List<T> entities) {
        this.doUpdateAsynchronously(entities, null, null);
        return entities;
    }

    @Override
    public <T> List<T> updateAsynchronously(List<T> entities, WriteOptions options) {
        this.doUpdateAsynchronously(entities, null, options);
        return entities;
    }

    @Override
    public <T> Cancellable updateAsynchronously(List<T> entities, WriteListener<T> listener) {
        return this.doUpdateAsynchronously(entities, listener, null);
    }

    @Override
    public <T> Cancellable updateAsynchronously(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doUpdateAsynchronously(entities, listener, options);
    }

    protected <T> Cancellable doUpdateAsynchronously(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doBatchUpdateAsync(entities, listener, options);
    }

    @Override
    public <T> T updateAsynchronously(T entity) {
        this.updateAsynchronously(entity, null, null);
        return entity;
    }

    @Override
    public <T> T updateAsynchronously(T entity, WriteOptions options) {
        this.updateAsynchronously(entity, null, options);
        return entity;
    }

    @Override
    public <T> Cancellable updateAsynchronously(T entity, WriteListener<T> listener) {
        return this.updateAsynchronously(entity, listener, null);
    }

    @Override
    public <T> Cancellable updateAsynchronously(T entity, WriteListener<T> listener, WriteOptions options) {
        return this.doUpdateAsync(entity, listener, options);
    }

    protected <T> List<T> select(String query, CassandraConverterRowCallback<T> rowCallback) {
        return this.processResultSet(this.doExecuteQueryReturnResultSet(query), rowCallback);
    }

    protected <T> List<T> select(Select query, CassandraConverterRowCallback<T> rowCallback) {
        return this.processResultSet(this.doExecuteQueryReturnResultSet(query), rowCallback);
    }

    private <T> List<T> processResultSet(ResultSet resultSet, RowCallback<T> rowCallback) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Row row : EmptyResultSet.nullSafeResultSet((ResultSet)resultSet)) {
            result.add(rowCallback.doWith(row));
        }
        return result;
    }

    @Override
    public <T> Iterator<T> stream(String query, Class<T> entityClass) {
        Assert.hasText((String)query, (String)"Query must not be empty");
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        ResultSet resultSet = this.doExecuteQueryReturnResultSet(query);
        return resultSet != null ? this.toIterator(resultSet, entityClass) : Collections.emptyIterator();
    }

    private <T> Iterator<T> toIterator(ResultSet resultSet, Class<T> entityClass) {
        return new ResultSetIteratorAdapter<T>(resultSet.iterator(), (PersistenceExceptionTranslator)this.getExceptionTranslator(), new CassandraConverterRowCallback<T>(this.cassandraConverter, entityClass));
    }

    protected <T> T selectOne(String query, CassandraConverterRowCallback<T> rowCallback) {
        Iterator iterator = this.query(this.logCql(query)).iterator();
        T result = null;
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            result = rowCallback.doWith(row);
            if (iterator.hasNext()) {
                throw new DuplicateKeyException(String.format("found two or more results in query [%s]", query));
            }
        }
        return result;
    }

    protected <T> T selectOne(Select query, CassandraConverterRowCallback<T> rowCallback) {
        Iterator iterator = this.query(query).iterator();
        T result = null;
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            result = rowCallback.doWith(row);
            if (iterator.hasNext()) {
                throw new DuplicateKeyException(String.format("found two or more results in query [%s]", query));
            }
        }
        return result;
    }

    protected <T> void doBatchDelete(List<T> entities, QueryOptions options) {
        this.execute(CassandraTemplate.createDeleteBatchQuery(this.getTableName(entities.get(0).getClass()).toCql(), entities, options, (EntityWriter<Object, Object>)this.cassandraConverter));
    }

    protected <T> Cancellable doBatchDeleteAsync(final List<T> entities, final DeletionListener<T> listener, QueryOptions options) {
        AsynchronousQueryListener queryListener = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    resultSetFuture.getUninterruptibly();
                    listener.onDeletionComplete(entities);
                }
                catch (Exception e) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(e));
                }
            }
        };
        return this.executeAsynchronously(CassandraTemplate.createDeleteBatchQuery(this.getTableName(entities.get(0).getClass()).toCql(), entities, options, (EntityWriter<Object, Object>)this.cassandraConverter), queryListener);
    }

    protected <T> T doInsert(T entity, WriteOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        this.execute(this.createInsertQuery(entity, options));
        return entity;
    }

    <T> Insert createInsertQuery(T entity, WriteOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return CassandraTemplate.createInsertQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
    }

    protected <T> Cancellable doInsertAsync(final T entity, final WriteListener<T> listener, WriteOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Insert insert = this.createInsertQuery(entity, options);
        AsynchronousQueryListener queryListener = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    resultSetFuture.getUninterruptibly();
                    listener.onWriteComplete(Collections.singletonList(entity));
                }
                catch (Exception x) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(x));
                }
            }
        };
        return this.executeAsynchronously(insert, queryListener);
    }

    protected <T> List<T> doBatchInsert(List<T> entities, WriteOptions options) {
        return this.doBatchWrite(entities, options, true);
    }

    protected <T> List<T> doBatchUpdate(List<T> entities, WriteOptions options) {
        return this.doBatchWrite(entities, options, false);
    }

    protected <T> List<T> doBatchWrite(List<T> entities, WriteOptions options, boolean insert) {
        if (CollectionUtils.isEmpty(entities)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("no-op due to given null or empty List");
            }
            return entities;
        }
        String tableName = this.getTableName(entities.get(0).getClass()).toCql();
        Batch batch = insert ? CassandraTemplate.createInsertBatchQuery(tableName, entities, options, (EntityWriter<Object, Object>)this.cassandraConverter) : CassandraTemplate.createUpdateBatchQuery(tableName, entities, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        this.execute(batch);
        return entities;
    }

    protected <T> Cancellable doBatchInsertAsync(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doBatchWriteAsync(entities, listener, options, true);
    }

    protected <T> Cancellable doBatchUpdateAsync(List<T> entities, WriteListener<T> listener, WriteOptions options) {
        return this.doBatchWriteAsync(entities, listener, options, false);
    }

    protected <T> Cancellable doBatchWriteAsync(final List<T> entities, final WriteListener<T> listener, WriteOptions options, boolean insert) {
        if (CollectionUtils.isEmpty(entities)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("no-op due to given null or empty list");
            }
            return new Cancellable(){

                public void cancel() {
                    if (CassandraTemplate.this.logger.isWarnEnabled()) {
                        CassandraTemplate.this.logger.warn("no-op query cancellation due to given null or empty list");
                    }
                }
            };
        }
        String tableName = this.getTableName(entities.get(0).getClass()).toCql();
        Batch batch = insert ? CassandraTemplate.createInsertBatchQuery(tableName, entities, options, (EntityWriter<Object, Object>)this.cassandraConverter) : CassandraTemplate.createUpdateBatchQuery(tableName, entities, options, (EntityWriter<Object, Object>)this.cassandraConverter);
        AsynchronousQueryListener queryListener = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    resultSetFuture.getUninterruptibly();
                    listener.onWriteComplete(entities);
                }
                catch (Exception e) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(e));
                }
            }
        };
        return this.executeAsynchronously(batch, queryListener);
    }

    <T> Delete createDeleteQuery(T entity, QueryOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return CassandraTemplate.createDeleteQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
    }

    protected <T> void doDelete(T entity, QueryOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        this.execute(this.createDeleteQuery(entity, options));
    }

    protected <T> Cancellable doDeleteAsync(final T entity, final DeletionListener<T> listener, QueryOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Delete delete = this.createDeleteQuery(entity, options);
        AsynchronousQueryListener queryListener = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    resultSetFuture.getUninterruptibly();
                    listener.onDeletionComplete(Collections.singletonList(entity));
                }
                catch (Exception x) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(x));
                }
            }
        };
        return this.executeAsynchronously(delete, queryListener);
    }

    <T> Update createUpdateQuery(T entity, WriteOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return CassandraTemplate.createUpdateQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.cassandraConverter);
    }

    protected <T> T doUpdate(T entity, WriteOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        this.execute(this.createUpdateQuery(entity, options));
        return entity;
    }

    protected <T> Cancellable doUpdateAsync(final T entity, final WriteListener<T> listener, WriteOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        AsynchronousQueryListener queryListener = listener == null ? null : new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    resultSetFuture.getUninterruptibly();
                    listener.onWriteComplete(Collections.singletonList(entity));
                }
                catch (Exception x) {
                    listener.onException(CassandraTemplate.this.translateExceptionIfPossible(x));
                }
            }
        };
        return this.executeAsynchronously(this.createUpdateQuery(entity, options), queryListener);
    }

    @Override
    public CassandraBatchOperations batchOps() {
        return new CassandraBatchTemplate(this);
    }

    public static Insert createInsertQuery(String tableName, Object objectToUpdate, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull((Object)objectToUpdate, (String)"Object to insert must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Insert insert = CassandraTemplate.addWriteOptions((Insert)QueryBuilder.insertInto((String)tableName), (WriteOptions)options);
        entityWriter.write(objectToUpdate, (Object)insert);
        return insert;
    }

    public static <T> Batch createInsertBatchQuery(String tableName, List<T> objectsToInsert, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull(objectsToInsert, (String)"Objects to insert must not be null");
        Assert.notEmpty(objectsToInsert, (String)"Objects to insert must not be empty");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Batch batch = (Batch)CassandraTemplate.addQueryOptions((Statement)QueryBuilder.batch((RegularStatement[])new RegularStatement[0]), (QueryOptions)options);
        for (T entity : objectsToInsert) {
            batch.add((RegularStatement)CassandraTemplate.createInsertQuery(tableName, entity, options, entityWriter));
        }
        return batch;
    }

    public static Update createUpdateQuery(String tableName, Object objectToUpdate, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull((Object)objectToUpdate, (String)"Object to update must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Update update = CassandraTemplate.addWriteOptions((Update)QueryBuilder.update((String)tableName), (WriteOptions)options);
        entityWriter.write(objectToUpdate, (Object)update);
        return update;
    }

    public static <T> Batch createUpdateBatchQuery(String tableName, List<T> objectsToUpdate, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull(objectsToUpdate, (String)"Objects to update must not be null");
        Assert.notEmpty(objectsToUpdate, (String)"Objects to update must not be empty");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Batch batch = (Batch)CassandraTemplate.addQueryOptions((Statement)QueryBuilder.batch((RegularStatement[])new RegularStatement[0]), (QueryOptions)options);
        for (T objectToSave : objectsToUpdate) {
            batch.add((RegularStatement)CassandraTemplate.createUpdateQuery(tableName, objectToSave, options, entityWriter));
        }
        return batch;
    }

    @Deprecated
    public static <T> Batch toUpdateBatchQuery(String tableName, List<T> objectsToUpdate, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        return CassandraTemplate.createUpdateBatchQuery(tableName, objectsToUpdate, options, entityWriter);
    }

    @Deprecated
    public static Update toUpdateQueryX(String tableName, Object objectToUpdate, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        return CassandraTemplate.createUpdateQuery(tableName, objectToUpdate, options, entityWriter);
    }

    public static Delete createDeleteQuery(String tableName, Object objectToDelete, QueryOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull((Object)objectToDelete, (String)"Object to delete must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Delete.Selection deleteSelection = QueryBuilder.delete();
        Delete delete = deleteSelection.from(tableName);
        Delete.Where where = (Delete.Where)CassandraTemplate.addQueryOptions((Statement)delete.where(), (QueryOptions)options);
        entityWriter.write(objectToDelete, (Object)where);
        return delete;
    }

    public static <T> Batch createDeleteBatchQuery(String tableName, List<T> objectsToDelete, QueryOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull(objectsToDelete, (String)"Objects to delete must not be null");
        Assert.notEmpty(objectsToDelete, (String)"Objects to delete must not be empty");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Batch batch = (Batch)CassandraTemplate.addQueryOptions((Statement)QueryBuilder.batch((RegularStatement[])new RegularStatement[0]), (QueryOptions)options);
        for (T entity : objectsToDelete) {
            batch.add((RegularStatement)CassandraTemplate.createDeleteQuery(tableName, entity, options, entityWriter));
        }
        return batch;
    }

    @Override
    public <T> void deleteAll(Class<T> entityClass) {
        this.truncate(this.getPersistentEntity(entityClass).getTableName());
    }

    @Override
    public <T> Cancellable selectOneAsynchronously(Select select, Class<T> type, QueryForObjectListener<T> listener) {
        return this.selectOneAsynchronously(select, type, listener, null);
    }

    @Override
    public <T> Cancellable selectOneAsynchronously(String cql, Class<T> entityClass, QueryForObjectListener<T> listener) {
        return this.selectOneAsynchronously(cql, entityClass, listener, null);
    }

    @Override
    public <T> Cancellable selectOneAsynchronously(Select select, Class<T> entityClass, QueryForObjectListener<T> listener, QueryOptions options) {
        return this.doSelectOneAsync(select, entityClass, listener, options);
    }

    @Override
    public <T> Cancellable selectOneAsynchronously(String cql, Class<T> entityClass, QueryForObjectListener<T> listener, QueryOptions options) {
        return this.doSelectOneAsync(cql, entityClass, listener, options);
    }

    private <T> CassandraPersistentEntity<?> getPersistentEntity(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (entity == null) {
            throw new InvalidDataAccessApiUsageException(String.format("No Persistent Entity information found for the class [%s]", entityClass.getName()));
        }
        return entity;
    }

    protected <T> Cancellable doSelectOneAsync(final Object query, final Class<T> entityClass, final QueryForObjectListener<T> listener, QueryOptions options) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        AsynchronousQueryListener queryListener = new AsynchronousQueryListener(){

            public void onQueryComplete(ResultSetFuture resultSetFuture) {
                try {
                    ResultSet resultSet = resultSetFuture.getUninterruptibly();
                    Iterator iterator = resultSet.iterator();
                    if (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        Object result = new CassandraConverterRowCallback(CassandraTemplate.this.cassandraConverter, entityClass).doWith(row);
                        if (iterator.hasNext()) {
                            throw new DuplicateKeyException(String.format("found two or more results in query [%s]", query));
                        }
                        listener.onQueryComplete(result);
                    } else {
                        listener.onQueryComplete(null);
                    }
                }
                catch (Exception e) {
                    listener.onException((Exception)CassandraTemplate.this.translateExceptionIfPossible(e));
                }
            }
        };
        if (query instanceof String) {
            return this.queryAsynchronously((String)query, queryListener, options);
        }
        if (query instanceof Select) {
            return this.queryAsynchronously((Select)query, queryListener);
        }
        throw new IllegalArgumentException(String.format("Expected type String or Select; got type [%1$s] with value [%2$s]", query.getClass(), query));
    }

    private static class ResultSetIteratorAdapter<T>
    implements Iterator<T> {
        private final CassandraConverterRowCallback<T> rowCallback;
        private final Iterator<Row> iterator;
        private final PersistenceExceptionTranslator exceptionTranslator;

        public ResultSetIteratorAdapter(Iterator<Row> iterator, PersistenceExceptionTranslator exceptionTranslator, CassandraConverterRowCallback<T> rowCallback) {
            this.iterator = iterator;
            this.exceptionTranslator = exceptionTranslator;
            this.rowCallback = rowCallback;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (Exception e) {
                throw CassandraTemplate.translateExceptionIfPossible((Throwable)e, (PersistenceExceptionTranslator)this.exceptionTranslator);
            }
        }

        @Override
        public T next() {
            try {
                return this.rowCallback.doWith(this.iterator.next());
            }
            catch (Exception e) {
                throw CassandraTemplate.translateExceptionIfPossible((Throwable)e, (PersistenceExceptionTranslator)this.exceptionTranslator);
            }
        }
    }

    protected static interface ClauseCallback {
        public void doWithClause(Clause var1);
    }
}

