/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cassandra.core.converter.ResultSetToBigDecimalConverter;
import org.springframework.cassandra.core.converter.ResultSetToBigIntegerConverter;
import org.springframework.cassandra.core.converter.ResultSetToBooleanConverter;
import org.springframework.cassandra.core.converter.ResultSetToByteBufferConverter;
import org.springframework.cassandra.core.converter.ResultSetToDateConverter;
import org.springframework.cassandra.core.converter.ResultSetToDoubleConverter;
import org.springframework.cassandra.core.converter.ResultSetToFloatConverter;
import org.springframework.cassandra.core.converter.ResultSetToInetAddressConverter;
import org.springframework.cassandra.core.converter.ResultSetToIntegerConverter;
import org.springframework.cassandra.core.converter.ResultSetToListConverter;
import org.springframework.cassandra.core.converter.ResultSetToLongConverter;
import org.springframework.cassandra.core.converter.ResultSetToStringConverter;
import org.springframework.cassandra.core.converter.ResultSetToUuidConverter;
import org.springframework.cassandra.core.converter.RowToMapConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParametersParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractCassandraQuery
implements RepositoryQuery {
    protected static final Converter<?, ?>[] DEFAULT_CONVERTERS = new Converter[]{new ResultSetToListConverter(), new ResultSetToStringConverter(), new RowToMapConverter(), new ResultSetToBigDecimalConverter(), new ResultSetToBigIntegerConverter(), new ResultSetToBooleanConverter(), new ResultSetToByteBufferConverter(), new ResultSetToDateConverter(), new ResultSetToDoubleConverter(), new ResultSetToFloatConverter(), new ResultSetToInetAddressConverter(), new ResultSetToIntegerConverter(), new ResultSetToLongConverter(), new ResultSetToUuidConverter()};
    protected static Logger log = LoggerFactory.getLogger(AbstractCassandraQuery.class);
    private ConversionService conversionService;
    Converter<ResultSet, List<Map<String, Object>>> resultSetToListConverter = new ResultSetToListConverter();
    private final CassandraQueryMethod method;
    private final CassandraOperations template;
    protected RowToMapConverter rowToMapConverter = new RowToMapConverter();

    public AbstractCassandraQuery(CassandraQueryMethod method, CassandraOperations operations) {
        Assert.notNull((Object)operations);
        Assert.notNull((Object)((Object)method));
        this.method = method;
        this.template = operations;
        this.conversionService = this.createDefaultConversionService();
    }

    protected ConfigurableConversionService createDefaultConversionService() {
        DefaultConversionService conversionService = new DefaultConversionService();
        for (Converter<?, ?> converter : DEFAULT_CONVERTERS) {
            conversionService.addConverter(converter);
        }
        return conversionService;
    }

    public CassandraQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        CassandraParametersParameterAccessor accessor = new CassandraParametersParameterAccessor(this.method, parameters);
        String query = this.createQuery(accessor);
        ResultSet resultSet = this.template.query(query);
        if (this.method.isResultSetQuery()) {
            return resultSet;
        }
        Class declaredReturnType = this.method.getReturnType().getType();
        Class returnedUnwrappedObjectType = this.method.getReturnedObjectType();
        if (this.method.isSingleEntityQuery()) {
            return this.getSingleEntity(resultSet, returnedUnwrappedObjectType);
        }
        Object retval = resultSet;
        if (this.method.isCollectionOfEntityQuery()) {
            retval = this.getCollectionOfEntity(resultSet, declaredReturnType, returnedUnwrappedObjectType);
        }
        return this.conversionService.convert(retval, TypeDescriptor.forObject((Object)retval), TypeDescriptor.valueOf((Class)declaredReturnType));
    }

    public Object getCollectionOfEntity(ResultSet resultSet, Class<?> declaredReturnType, Class<?> returnedUnwrappedObjectType) {
        AbstractCollection results = null;
        results = ClassUtils.isAssignable(SortedSet.class, declaredReturnType) ? new TreeSet() : (ClassUtils.isAssignable(Set.class, declaredReturnType) ? new HashSet() : new ArrayList());
        CassandraConverter converter = this.template.getConverter();
        for (Row row : resultSet) {
            results.add(converter.read(returnedUnwrappedObjectType, row));
        }
        return results;
    }

    public Object getSingleEntity(ResultSet resultSet, Class<?> type) {
        if (resultSet.isExhausted()) {
            return null;
        }
        Iterator iterator = resultSet.iterator();
        Object object = this.template.getConverter().read(type, iterator.next());
        this.warnIfMoreResults(iterator);
        return object;
    }

    protected void warnIfMoreResults(Iterator<Row> iterator) {
        if (log.isWarnEnabled() && iterator.hasNext()) {
            int i = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++i;
            }
            log.warn("ignoring extra {} row{}", (Object)i, (Object)(i == 1 ? "" : "s"));
        }
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService);
        this.conversionService = conversionService;
    }

    protected abstract String createQuery(CassandraParameterAccessor var1);
}

