/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.cassandra.mapping.PropertyMapping;
import org.springframework.util.Assert;

public class EntityMapping {
    protected String entityClassName;
    protected String tableName = "";
    protected String forceQuote = "false";
    protected Map<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>();

    public EntityMapping(String entityClassName, String tableName) {
        this(entityClassName, tableName, Boolean.FALSE.toString());
    }

    public EntityMapping(String entityClassName, String tableName, String forceQuote) {
        this.setEntityClassName(entityClassName);
        this.setTableName(tableName);
        this.setForceQuote(forceQuote);
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    public void setEntityClassName(String entityClassName) {
        Assert.hasText((String)entityClassName);
        this.entityClassName = entityClassName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        Assert.notNull((Object)tableName);
        this.tableName = tableName;
    }

    public String getForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(String forceQuote) {
        Assert.notNull((Object)forceQuote);
        this.forceQuote = forceQuote;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (!(that instanceof EntityMapping)) {
            return false;
        }
        EntityMapping other = (EntityMapping)that;
        return this.entityClassName.equals(other.entityClassName) && this.forceQuote.equals(other.forceQuote) && this.tableName.equals(other.tableName);
    }

    public int hashCode() {
        return this.entityClassName.hashCode() ^ this.forceQuote.hashCode() ^ this.tableName.hashCode();
    }

    public void setPropertyMappings(Map<String, PropertyMapping> propertyMappings) {
        propertyMappings = propertyMappings == null ? new HashMap() : propertyMappings;
        this.propertyMappings = new HashMap<String, PropertyMapping>(propertyMappings);
    }

    public Map<String, PropertyMapping> getPropertyMappings() {
        return Collections.unmodifiableMap(this.propertyMappings);
    }
}

