/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.cassandra.config.BeanDefinitionBuilderArgument;
import org.springframework.util.StringUtils;

public class BeanDefinitionUtils {
    public static BeanDefinitionBuilder createBeanDefinitionBuilderIfNoBeanDefinitionOfTypeExists(ListableBeanFactory factory, Class<?> requiredType, Class<?> instantiableType, BeanDefinitionBuilderArgument ... constructorArgs) {
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)factory, requiredType, (boolean)true, (boolean)false);
        if (names.length > 0) {
            return null;
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(instantiableType);
        if (constructorArgs == null) {
            return builder;
        }
        for (BeanDefinitionBuilderArgument arg : constructorArgs) {
            if (arg.reference) {
                builder.addConstructorArgReference(arg.value.toString());
                continue;
            }
            builder.addConstructorArgValue(arg.value);
        }
        return builder;
    }

    public static BeanDefinitionHolder getSingleBeanDefinitionOfType(BeanDefinitionRegistry registry, ListableBeanFactory factory, Class<?> type, boolean includeNonSingletons, boolean allowEagerInit, boolean required) {
        BeanDefinitionHolder[] definitions = BeanDefinitionUtils.getBeanDefinitionsOfType(registry, factory, type, includeNonSingletons, allowEagerInit);
        if (definitions.length == 1) {
            return definitions[0];
        }
        if (definitions.length == 0 && !required) {
            return null;
        }
        Object[] names = new String[definitions.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = definitions[i].getBeanName();
        }
        throw new IllegalStateException(String.format("expected one bean definition of type [%s], but found %d: %s", type.getName(), definitions.length, StringUtils.arrayToCommaDelimitedString((Object[])names)));
    }

    public static BeanDefinitionHolder[] getBeanDefinitionsOfType(BeanDefinitionRegistry registry, ListableBeanFactory factory, Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)factory, type, (boolean)includeNonSingletons, (boolean)allowEagerInit);
        if (names.length == 0) {
            return new BeanDefinitionHolder[0];
        }
        BeanDefinitionHolder[] array = new BeanDefinitionHolder[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            BeanDefinition beanDefinition = null;
            while (beanDefinition == null) {
                try {
                    beanDefinition = registry.getBeanDefinition(name);
                }
                catch (NoSuchBeanDefinitionException x) {
                    if (FactoryBean.class.isAssignableFrom(type)) {
                        name = name.substring("&".length());
                        continue;
                    }
                    throw x;
                }
            }
            array[i] = new BeanDefinitionHolder(beanDefinition, name);
        }
        return array;
    }
}

