/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.util;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpelUtils {
    public static final SpelExpressionParser DEFAULT_PARSER = new SpelExpressionParser();

    public static String evaluate(CharSequence value, EvaluationContext context) {
        return SpelUtils.evaluate(value, context, (ExpressionParser)DEFAULT_PARSER);
    }

    public static String evaluate(CharSequence value, EvaluationContext context, ExpressionParser parser) {
        return SpelUtils.evaluate(value, context, String.class, parser);
    }

    public static <T> T evaluate(CharSequence value, EvaluationContext context, Class<T> clazz) {
        return SpelUtils.evaluate(value, context, clazz, (ExpressionParser)DEFAULT_PARSER);
    }

    public static <T> T evaluate(CharSequence value, EvaluationContext context, Class<T> clazz, ExpressionParser parser) {
        Expression expression = parser.parseExpression(value.toString(), ParserContext.TEMPLATE_EXPRESSION);
        return (T)expression.getValue(context, clazz);
    }
}

