/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cassandra.config.KeyspaceAction;
import org.springframework.cassandra.core.keyspace.CreateKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.DefaultOption;
import org.springframework.cassandra.core.keyspace.DropKeyspaceSpecification;
import org.springframework.cassandra.core.keyspace.KeyspaceActionSpecification;
import org.springframework.cassandra.core.keyspace.KeyspaceOption;
import org.springframework.util.Assert;

public class KeyspaceActionSpecificationFactoryBean
implements FactoryBean<Set<KeyspaceActionSpecification<?>>>,
InitializingBean,
DisposableBean {
    private KeyspaceAction action;
    private String name;
    private List<String> networkTopologyDataCenters = new LinkedList<String>();
    private List<String> networkTopologyReplicationFactors = new LinkedList<String>();
    private KeyspaceOption.ReplicationStrategy replicationStrategy;
    private long replicationFactor;
    private boolean durableWrites = false;
    private boolean ifNotExists = false;
    private Set<KeyspaceActionSpecification<?>> specs = new HashSet();

    public void destroy() throws Exception {
        this.action = null;
        this.name = null;
        this.networkTopologyDataCenters = null;
        this.networkTopologyReplicationFactors = null;
        this.replicationStrategy = null;
        this.specs = null;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.name, (String)"Keyspace Name is required for a Keyspace Action");
        Assert.notNull((Object)((Object)this.action), (String)"Keyspace Action is required for a Keyspace Action");
        switch (this.action) {
            case CREATE_DROP: {
                this.specs.add(this.generateDropKeyspaceSpecification());
            }
            case CREATE: {
                this.specs.add(this.generateCreateKeyspaceSpecification());
                break;
            }
        }
    }

    private CreateKeyspaceSpecification generateCreateKeyspaceSpecification() {
        CreateKeyspaceSpecification create = new CreateKeyspaceSpecification();
        create.name(this.name).ifNotExists(this.ifNotExists).with(KeyspaceOption.DURABLE_WRITES, this.durableWrites);
        HashMap<DefaultOption, Object> replicationStrategyMap = new HashMap<DefaultOption, Object>();
        replicationStrategyMap.put(new DefaultOption("class", String.class, true, false, true), this.replicationStrategy.getValue());
        if (this.replicationStrategy == KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY) {
            replicationStrategyMap.put(new DefaultOption("replication_factor", Long.class, true, false, false), this.replicationFactor);
        }
        if (this.replicationStrategy == KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY) {
            int i = 0;
            for (String datacenter : this.networkTopologyDataCenters) {
                replicationStrategyMap.put(new DefaultOption(datacenter, Long.class, true, false, false), this.networkTopologyReplicationFactors.get(i++));
            }
        }
        create.with(KeyspaceOption.REPLICATION, replicationStrategyMap);
        return create;
    }

    private DropKeyspaceSpecification generateDropKeyspaceSpecification() {
        DropKeyspaceSpecification drop = new DropKeyspaceSpecification();
        drop.name(this.getName());
        return drop;
    }

    public Set<KeyspaceActionSpecification<?>> getObject() throws Exception {
        return this.specs;
    }

    public Class<?> getObjectType() {
        return Set.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public KeyspaceAction getAction() {
        return this.action;
    }

    public void setAction(KeyspaceAction action) {
        this.action = action;
    }

    public boolean isDurableWrites() {
        return this.durableWrites;
    }

    public void setDurableWrites(boolean durableWrites) {
        this.durableWrites = durableWrites;
    }

    public KeyspaceOption.ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public void setReplicationStrategy(KeyspaceOption.ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
    }

    public List<String> getNetworkTopologyDataCenters() {
        return this.networkTopologyDataCenters;
    }

    public void setNetworkTopologyDataCenters(List<String> networkTopologyDataCenters) {
        this.networkTopologyDataCenters = networkTopologyDataCenters;
    }

    public List<String> getNetworkTopologyReplicationFactors() {
        return this.networkTopologyReplicationFactors;
    }

    public void setNetworkTopologyReplicationFactors(List<String> networkTopologyReplicationFactors) {
        this.networkTopologyReplicationFactors = networkTopologyReplicationFactors;
    }

    public long getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(long replicationFactor) {
        this.replicationFactor = replicationFactor;
    }
}

