/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cassandra.config.CassandraCqlSessionFactoryBean;
import org.springframework.cassandra.config.xml.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class CassandraCqlSessionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return CassandraCqlSessionFactoryBean.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraSession";
    }

    protected void parseUnhandledElement(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        throw new IllegalStateException(String.format("encountered unhandled element [%s]", element.getLocalName()));
    }

    protected void parseUnhandledSessionElementAttribute(Attr attribute, ParserContext parserContext, BeanDefinitionBuilder builder) {
        throw new IllegalStateException(String.format("encountered unhandled session element attribute [%s]", attribute.getName()));
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.setDefaultProperties(builder);
        this.parseSessionAttributes(element, parserContext, builder);
        this.parseSessionChildElements(element, parserContext, builder);
    }

    protected void setDefaultProperties(BeanDefinitionBuilder builder) {
        ParsingUtils.addRequiredPropertyReference(builder, "cluster", "cassandraCluster");
    }

    protected void parseSessionAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if ("id".equals(attribute.getName())) continue;
            String name = attribute.getName();
            if ("keyspace-name".equals(name)) {
                ParsingUtils.addRequiredPropertyValue(builder, "keyspaceName", attribute);
                continue;
            }
            if ("cluster-ref".equals(name)) {
                ParsingUtils.addOptionalPropertyReference(builder, "cluster", attribute, "cassandraCluster");
                continue;
            }
            this.parseUnhandledSessionElementAttribute(attribute, parserContext, builder);
        }
    }

    protected void parseSessionChildElements(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        for (Element child : DomUtils.getChildElements((Element)element)) {
            if ("startup-cql".equals(child.getLocalName())) {
                builder.addPropertyValue("startupScripts", (Object)DomUtils.getTextValue((Element)child));
                continue;
            }
            if ("shutdown-cql".equals(child.getLocalName())) {
                builder.addPropertyValue("shutdownScripts", (Object)DomUtils.getTextValue((Element)child));
                continue;
            }
            this.parseUnhandledElement(child, parserContext, builder);
        }
    }
}

