/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql;

import com.datastax.driver.core.DataType;

public class CqlStringUtils {
    protected static final String SINGLE_QUOTE = "'";
    protected static final String DOUBLE_SINGLE_QUOTE = "''";
    public static final String DOUBLE_QUOTE = "\"";
    protected static final String DOUBLE_DOUBLE_QUOTE = "\"\"";
    protected static final String EMPTY_STRING = "";
    protected static final String TYPE_PARAMETER_PREFIX = "<";
    protected static final String TYPE_PARAMETER_SUFFIX = ">";

    public static StringBuilder noNull(StringBuilder sb) {
        return sb == null ? new StringBuilder() : sb;
    }

    public static String valuize(String candidate) {
        if (candidate == null) {
            return null;
        }
        return CqlStringUtils.singleQuote(CqlStringUtils.escapeSingle(candidate));
    }

    public static String escapeSingle(Object thing) {
        return thing == null ? (String)null : thing.toString().replace(SINGLE_QUOTE, DOUBLE_SINGLE_QUOTE);
    }

    public static String escapeDouble(Object thing) {
        return thing == null ? (String)null : thing.toString().replace(DOUBLE_QUOTE, DOUBLE_DOUBLE_QUOTE);
    }

    public static String singleQuote(Object thing) {
        return thing == null ? (String)null : SINGLE_QUOTE + thing + SINGLE_QUOTE;
    }

    public static String doubleQuote(Object thing) {
        return thing == null ? (String)null : DOUBLE_QUOTE + thing + DOUBLE_QUOTE;
    }

    public static String removeSingleQuotes(Object thing) {
        return thing == null ? (String)null : ((String)thing).replaceAll(SINGLE_QUOTE, EMPTY_STRING);
    }

    public static String toCql(DataType dataType) {
        if (dataType.getTypeArguments().isEmpty()) {
            return dataType.getName().name();
        }
        StringBuilder s = new StringBuilder();
        s.append(dataType.getName().name()).append(TYPE_PARAMETER_PREFIX);
        boolean first = true;
        for (DataType argDataType : dataType.getTypeArguments()) {
            if (first) {
                first = false;
            } else {
                s.append(',');
            }
            s.append(argDataType.getName().name());
        }
        return s.append(TYPE_PARAMETER_SUFFIX).toString();
    }

    public static String unquote(String s) {
        return CqlStringUtils.unquote(s, DOUBLE_QUOTE);
    }

    public static String unquote(String s, String quoteChar) {
        if (s == null) {
            return s;
        }
        if (!s.startsWith(quoteChar) || !s.endsWith(quoteChar)) {
            return s;
        }
        if (s.length() <= 2) {
            return s;
        }
        return s.substring(1, s.length() - 1);
    }
}

