/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import java.util.Map;
import org.springframework.cassandra.core.keyspace.DefaultOption;
import org.springframework.cassandra.core.keyspace.Option;

public enum TableOption implements Option
{
    COMMENT("comment", String.class, true, true, true),
    COMPACT_STORAGE("COMPACT STORAGE", null, false, false, false),
    COMPACTION("compaction", Map.class, true, false, false),
    COMPRESSION("compression", Map.class, true, false, false),
    REPLICATE_ON_WRITE("replicate_on_write", Boolean.class, true, false, true),
    CACHING("caching", CachingOption.class, true, false, true),
    BLOOM_FILTER_FP_CHANCE("bloom_filter_fp_chance", Double.class, true, false, false),
    READ_REPAIR_CHANCE("read_repair_chance", Double.class, true, false, false),
    DCLOCAL_READ_REPAIR_CHANCE("dclocal_read_repair_chance", Double.class, true, false, false),
    GC_GRACE_SECONDS("gc_grace_seconds", Long.class, true, false, false);

    private Option delegate;

    private TableOption(String name, Class<?> type, boolean requiresValue, boolean escapesValue, boolean quotesValue) {
        this.delegate = new DefaultOption(name, type, requiresValue, escapesValue, quotesValue);
    }

    @Override
    public Class<?> getType() {
        return this.delegate.getType();
    }

    @Override
    public boolean takesValue() {
        return this.delegate.takesValue();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean escapesValue() {
        return this.delegate.escapesValue();
    }

    @Override
    public boolean quotesValue() {
        return this.delegate.quotesValue();
    }

    @Override
    public boolean requiresValue() {
        return this.delegate.requiresValue();
    }

    @Override
    public void checkValue(Object value) {
        this.delegate.checkValue(value);
    }

    @Override
    public boolean isCoerceable(Object value) {
        return this.delegate.isCoerceable(value);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String toString(Object value) {
        return this.delegate.toString(value);
    }

    public static enum CompressionOption implements Option
    {
        SSTABLE_COMPRESSION("sstable_compression", String.class, true, false, true),
        CHUNK_LENGTH_KB("chunk_length_kb", Long.class, true, false, false),
        CRC_CHECK_CHANCE("crc_check_chance", Double.class, true, false, false);

        private Option delegate;

        private CompressionOption(String name, Class<?> type, boolean requiresValue, boolean escapesValue, boolean quotesValue) {
            this.delegate = new DefaultOption(name, type, requiresValue, escapesValue, quotesValue);
        }

        @Override
        public Class<?> getType() {
            return this.delegate.getType();
        }

        @Override
        public boolean takesValue() {
            return this.delegate.takesValue();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean escapesValue() {
            return this.delegate.escapesValue();
        }

        @Override
        public boolean quotesValue() {
            return this.delegate.quotesValue();
        }

        @Override
        public boolean requiresValue() {
            return this.delegate.requiresValue();
        }

        @Override
        public void checkValue(Object value) {
            this.delegate.checkValue(value);
        }

        @Override
        public boolean isCoerceable(Object value) {
            return this.delegate.isCoerceable(value);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String toString(Object value) {
            return this.delegate.toString(value);
        }
    }

    public static enum CompactionOption implements Option
    {
        CLASS("class", String.class, true, false, true),
        TOMBSTONE_THRESHOLD("tombstone_threshold", Double.class, true, false, false),
        TOMBSTONE_COMPACTION_INTERVAL("tombstone_compaction_interval", Double.class, true, false, false),
        MIN_SSTABLE_SIZE("min_sstable_size", Long.class, true, false, false),
        MIN_THRESHOLD("min_threshold", Long.class, true, false, false),
        MAX_THRESHOLD("max_threshold", Long.class, true, false, false),
        BUCKET_LOW("bucket_low", Double.class, true, false, false),
        BUCKET_HIGH("bucket_high", Double.class, true, false, false),
        SSTABLE_SIZE_IN_MB("sstable_size_in_mb", Long.class, true, false, false);

        private Option delegate;

        private CompactionOption(String name, Class<?> type, boolean requiresValue, boolean escapesValue, boolean quotesValue) {
            this.delegate = new DefaultOption(name, type, requiresValue, escapesValue, quotesValue);
        }

        @Override
        public Class<?> getType() {
            return this.delegate.getType();
        }

        @Override
        public boolean takesValue() {
            return this.delegate.takesValue();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean escapesValue() {
            return this.delegate.escapesValue();
        }

        @Override
        public boolean quotesValue() {
            return this.delegate.quotesValue();
        }

        @Override
        public boolean requiresValue() {
            return this.delegate.requiresValue();
        }

        @Override
        public void checkValue(Object value) {
            this.delegate.checkValue(value);
        }

        @Override
        public boolean isCoerceable(Object value) {
            return this.delegate.isCoerceable(value);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String toString(Object value) {
            return this.delegate.toString(value);
        }
    }

    public static enum CachingOption {
        ALL("all"),
        KEYS_ONLY("keys_only"),
        ROWS_ONLY("rows_only"),
        NONE("none");

        private String value;

        private CachingOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

