/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.cql;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.springframework.cassandra.core.ReservedKeyword;
import org.springframework.util.Assert;

public final class CqlIdentifier
implements Comparable<CqlIdentifier>,
Serializable {
    private static final long serialVersionUID = -974441606330912437L;
    public static final String UNQUOTED_REGEX = "(?i)[a-z][\\w]*";
    public static final Pattern UNQUOTED = Pattern.compile("(?i)[a-z][\\w]*");
    public static final String QUOTED_REGEX = "(?i)[a-z]([\\w]*(\"\")+[\\w]*)+";
    public static final Pattern QUOTED = Pattern.compile("(?i)[a-z]([\\w]*(\"\")+[\\w]*)+");
    private String identifier;
    private String unquoted;
    private boolean quoted;

    public static CqlIdentifier cqlId(CharSequence identifier) {
        return new CqlIdentifier(identifier);
    }

    public static CqlIdentifier cqlId(CharSequence identifier, boolean forceQuote) {
        return new CqlIdentifier(identifier, forceQuote);
    }

    public static CqlIdentifier quotedCqlId(CharSequence identifier) {
        return new CqlIdentifier(identifier, true);
    }

    public static boolean isUnquotedIdentifier(CharSequence chars) {
        return UNQUOTED.matcher(chars).matches() && !ReservedKeyword.isReserved(chars);
    }

    public static boolean isQuotedIdentifier(CharSequence chars) {
        return QUOTED.matcher(chars).matches() || ReservedKeyword.isReserved(chars);
    }

    public CqlIdentifier(CharSequence identifier) {
        this(identifier, false);
    }

    public CqlIdentifier(CharSequence identifier, boolean forceQuote) {
        this.setIdentifier(identifier, forceQuote);
    }

    private void setIdentifier(CharSequence identifier, boolean forceQuoting) {
        Assert.notNull((Object)identifier);
        String string = identifier.toString();
        Assert.hasText((String)string);
        if (forceQuoting || CqlIdentifier.isQuotedIdentifier(string)) {
            this.unquoted = string;
            this.identifier = "\"" + string + "\"";
            this.quoted = true;
        } else if (CqlIdentifier.isUnquotedIdentifier(string)) {
            this.identifier = this.unquoted = string.toLowerCase();
        } else {
            throw new IllegalArgumentException(String.format("given string [%s] is not a valid quoted or unquoted identifier", identifier));
        }
    }

    public String getUnquoted() {
        return this.unquoted;
    }

    public String toCql() {
        return this.identifier;
    }

    public StringBuilder toCql(StringBuilder sb) {
        sb = sb == null ? new StringBuilder() : sb;
        return sb.append(this.toCql());
    }

    public String toString() {
        return this.toCql();
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public int hashCode() {
        return Boolean.valueOf(this.quoted).hashCode() ^ this.identifier.hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof CqlIdentifier) && !(that instanceof CharSequence)) {
            return false;
        }
        CqlIdentifier other = that instanceof CqlIdentifier ? (CqlIdentifier)that : CqlIdentifier.cqlId((CharSequence)that);
        return this.quoted == other.quoted && this.identifier.equals(other.identifier);
    }

    @Override
    public int compareTo(CqlIdentifier that) {
        int comparison = Boolean.valueOf(this.quoted).compareTo(that.quoted);
        if (comparison != 0) {
            return comparison;
        }
        return this.identifier.compareTo(that.identifier);
    }
}

