/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import java.util.List;
import org.springframework.cassandra.core.PreparedStatementBinder;
import org.springframework.cassandra.core.PreparedStatementCreator;

public class PreparedStatementCreatorImpl
implements PreparedStatementCreator,
PreparedStatementBinder {
    private final String cql;
    private List<Object> values;

    public PreparedStatementCreatorImpl(String cql) {
        this.cql = cql;
    }

    public PreparedStatementCreatorImpl(String cql, List<Object> values) {
        this.cql = cql;
        this.values = values;
    }

    @Override
    public BoundStatement bindValues(PreparedStatement ps) throws DriverException {
        if (this.values == null) {
            return new BoundStatement(ps);
        }
        return ps.bind(this.values.toArray());
    }

    public String getCql() {
        return this.cql;
    }

    @Override
    public PreparedStatement createPreparedStatement(Session session) throws DriverException {
        return session.prepare(this.cql);
    }
}

