/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.converter;

import com.datastax.driver.core.ResultSet;
import java.util.List;
import java.util.Map;
import org.springframework.cassandra.core.converter.ResultSetToListConverter;
import org.springframework.core.convert.converter.Converter;

public abstract class AbstractResultSetConverter<T>
implements Converter<ResultSet, T> {
    protected ResultSetToListConverter converter = new ResultSetToListConverter();

    protected abstract T doConvertSingleValue(Object var1);

    protected abstract Class<?> getType();

    protected T getNullResultSetValue() {
        return null;
    }

    protected T getExhaustedResultSetValue() {
        return null;
    }

    public T convert(ResultSet source) {
        if (source == null) {
            return this.getNullResultSetValue();
        }
        if (source.isExhausted()) {
            return this.getExhaustedResultSetValue();
        }
        List<Map<String, Object>> list = this.converter.convert(source);
        if (list.size() == 1) {
            Map<String, Object> map = list.get(0);
            return map.size() == 1 ? this.doConvertSingleValue(map.get(map.keySet().iterator().next())) : this.doConvertSingleRow(map);
        }
        return this.doConvertResultSet(list);
    }

    protected T doConvertResultSet(List<Map<String, Object>> resultSet) {
        this.doThrow("result set");
        return null;
    }

    protected T doConvertSingleRow(Map<String, Object> row) {
        this.doThrow("row");
        return null;
    }

    protected void doThrow(String string) {
        throw new IllegalArgumentException(String.format("can't convert %s to desired type [%s]", string, this.getType().getName()));
    }
}

