/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigProperties;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySource;
import org.springframework.core.style.ToStringCreator;

public class ZookeeperPropertySources {
    private final ZookeeperConfigProperties properties;
    private final Log log;

    public ZookeeperPropertySources(ZookeeperConfigProperties properties, Log log) {
        this.properties = properties;
        this.log = log;
    }

    public List<String> getAutomaticContexts(List<String> profiles) {
        return this.getAutomaticContexts(profiles, true);
    }

    public List<String> getAutomaticContexts(List<String> profiles, boolean reverse) {
        return this.generateAutomaticContexts(profiles, reverse).stream().map(Context::getPath).collect(Collectors.toList());
    }

    public List<Context> generateAutomaticContexts(List<String> profiles, boolean reverse) {
        ArrayList<Context> contexts = new ArrayList<Context>();
        String root = this.properties.getRoot();
        String defaultContext = root + "/" + this.properties.getDefaultContext();
        contexts.add(new Context(defaultContext));
        this.addProfiles(contexts, defaultContext, profiles);
        StringBuilder baseContext = new StringBuilder(root);
        if (!this.properties.getName().startsWith("/")) {
            baseContext.append("/");
        }
        baseContext.append(this.properties.getName());
        contexts.add(new Context(baseContext.toString()));
        this.addProfiles(contexts, baseContext.toString(), profiles);
        if (reverse) {
            Collections.reverse(contexts);
        }
        return contexts;
    }

    private void addProfiles(List<Context> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            String path = baseContext + this.properties.getProfileSeparator() + profile;
            contexts.add(new Context(path, profile));
        }
    }

    public ZookeeperPropertySource createPropertySource(String context, boolean optional, CuratorFramework curator) {
        try {
            return new ZookeeperPropertySource(context, curator);
        }
        catch (Exception e) {
            if (this.properties.isFailFast() || !optional) {
                throw new ZookeeperPropertySourceNotFoundException(e);
            }
            this.log.warn((Object)("Unable to load zookeeper config from " + context), (Throwable)e);
            return null;
        }
    }

    public static class Context {
        private final String path;
        private final String profile;

        public Context(String path) {
            this.path = path;
            this.profile = null;
        }

        public Context(String path, String profile) {
            this.path = path;
            this.profile = profile;
        }

        public String getPath() {
            return this.path;
        }

        public String getProfile() {
            return this.profile;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("path", (Object)this.path).append("profile", (Object)this.profile).toString();
        }
    }

    static class ZookeeperPropertySourceNotFoundException
    extends RuntimeException {
        ZookeeperPropertySourceNotFoundException(Exception source) {
            super(source);
        }
    }
}

