/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config.aws;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.PropertyNameTransformer;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.cloud.vault.config.aws.VaultAwsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.vault.core.util.PropertyTransformer;

@Configuration
@EnableConfigurationProperties(value={VaultAwsProperties.class})
public class VaultConfigAwsBootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AwsSecretBackendMetadataFactory awsSecretBackendMetadataFactory() {
        return new AwsSecretBackendMetadataFactory();
    }

    public static class AwsSecretBackendMetadataFactory
    implements SecretBackendMetadataFactory<VaultAwsProperties> {
        public SecretBackendMetadata createMetadata(VaultAwsProperties backendDescriptor) {
            return AwsSecretBackendMetadataFactory.forAws(backendDescriptor);
        }

        public boolean supports(VaultSecretBackendDescriptor backendDescriptor) {
            return backendDescriptor instanceof VaultAwsProperties;
        }

        static SecretBackendMetadata forAws(final VaultAwsProperties properties) {
            Assert.notNull((Object)properties, (String)"VaultAwsProperties must not be null");
            final PropertyNameTransformer transformer = new PropertyNameTransformer();
            transformer.addKeyTransformation("access_key", properties.getAccessKeyProperty());
            transformer.addKeyTransformation("secret_key", properties.getSecretKeyProperty());
            return new SecretBackendMetadata(){

                public String getName() {
                    return String.format("%s with Role %s", properties.getBackend(), properties.getRole());
                }

                public String getPath() {
                    return String.format("%s/creds/%s", properties.getBackend(), properties.getRole());
                }

                public PropertyTransformer getPropertyTransformer() {
                    return transformer;
                }

                public Map<String, String> getVariables() {
                    HashMap<String, String> variables = new HashMap<String, String>();
                    variables.put("backend", properties.getBackend());
                    variables.put("key", String.format("creds/%s", properties.getRole()));
                    return variables;
                }
            };
        }
    }
}

