/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class EventEmittingItemProcessListener
implements ItemProcessListener,
Ordered {
    private static final Log logger = LogFactory.getLog(EventEmittingItemProcessListener.class);
    private MessagePublisher messagePublisher;
    private int order = Integer.MAX_VALUE;
    private TaskEventProperties properties;

    public EventEmittingItemProcessListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
        Assert.notNull((Object)messagePublisher, (String)"messagePublisher is required");
        Assert.notNull((Object)properties, (String)"properties is required");
        this.messagePublisher = messagePublisher;
        this.properties = properties;
    }

    public EventEmittingItemProcessListener(MessagePublisher messagePublisher, int order, TaskEventProperties properties) {
        this(messagePublisher, properties);
        this.order = order;
    }

    public void beforeProcess(Object item) {
    }

    public void afterProcess(Object item, Object result) {
        if (result == null) {
            this.messagePublisher.publish(this.properties.getItemProcessEventBindingName(), "1 item was filtered");
        } else if (item.equals(result)) {
            this.messagePublisher.publish(this.properties.getItemProcessEventBindingName(), "item equaled result after processing");
        } else {
            this.messagePublisher.publish(this.properties.getItemProcessEventBindingName(), "item did not equal result after processing");
        }
    }

    public void onProcessError(Object item, Exception e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onProcessError: " + e.getMessage()), (Throwable)e);
        }
        this.messagePublisher.publishWithThrowableHeader(this.properties.getItemProcessEventBindingName(), "Exception while item was being processed", e.getMessage());
    }

    public int getOrder() {
        return this.order;
    }
}

