/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.cloud.task.batch.listener.support.ExitStatus;
import org.springframework.util.Assert;

public class StepExecutionEvent
extends Entity {
    private long jobExecutionId;
    private String stepName;
    private BatchStatus status = BatchStatus.STARTING;
    private long readCount = 0L;
    private long writeCount = 0L;
    private long commitCount = 0L;
    private long rollbackCount = 0L;
    private long readSkipCount = 0L;
    private long processSkipCount = 0L;
    private long writeSkipCount = 0L;
    private LocalDateTime startTime = LocalDateTime.now();
    private LocalDateTime endTime = null;
    private LocalDateTime lastUpdated = null;
    private ExecutionContext executionContext = new ExecutionContext();
    private ExitStatus exitStatus = new ExitStatus(org.springframework.batch.core.ExitStatus.EXECUTING);
    private boolean terminateOnly;
    private long filterCount;
    private List<Throwable> failureExceptions = new CopyOnWriteArrayList<Throwable>();

    public StepExecutionEvent() {
    }

    public StepExecutionEvent(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution, (String)"StepExecution must be provided to re-hydrate an existing StepExecutionEvent");
        Assert.notNull((Object)stepExecution.getJobExecution(), (String)"JobExecution must be provided to re-hydrate an existing StepExecutionEvent");
        this.setId(stepExecution.getId());
        this.jobExecutionId = stepExecution.getJobExecutionId();
        this.stepName = stepExecution.getStepName();
        this.status = stepExecution.getStatus();
        this.exitStatus = new ExitStatus(stepExecution.getExitStatus());
        this.executionContext = stepExecution.getExecutionContext();
        for (Throwable throwable : stepExecution.getFailureExceptions()) {
            this.failureExceptions.add(throwable);
        }
        this.terminateOnly = stepExecution.isTerminateOnly();
        this.endTime = stepExecution.getEndTime();
        this.lastUpdated = stepExecution.getLastUpdated();
        this.startTime = stepExecution.getStartTime();
        this.commitCount = stepExecution.getCommitCount();
        this.filterCount = stepExecution.getFilterCount();
        this.processSkipCount = stepExecution.getProcessSkipCount();
        this.readCount = stepExecution.getReadCount();
        this.readSkipCount = stepExecution.getReadSkipCount();
        this.rollbackCount = stepExecution.getRollbackCount();
        this.writeCount = stepExecution.getWriteCount();
        this.writeSkipCount = stepExecution.getWriteSkipCount();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public void setReadCount(int readCount) {
        this.readCount = readCount;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public void setWriteCount(int writeCount) {
        this.writeCount = writeCount;
    }

    public long getRollbackCount() {
        return this.rollbackCount;
    }

    public void setRollbackCount(int rollbackCount) {
        this.rollbackCount = rollbackCount;
    }

    public long getFilterCount() {
        return this.filterCount;
    }

    public void setFilterCount(int filterCount) {
        this.filterCount = filterCount;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchStatus status) {
        this.status = status;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public boolean isTerminateOnly() {
        return this.terminateOnly;
    }

    public void setTerminateOnly() {
        this.terminateOnly = true;
    }

    public long getSkipCount() {
        return this.readSkipCount + this.processSkipCount + this.writeSkipCount;
    }

    public void incrementCommitCount() {
        ++this.commitCount;
    }

    public long getReadSkipCount() {
        return this.readSkipCount;
    }

    public void setReadSkipCount(int readSkipCount) {
        this.readSkipCount = readSkipCount;
    }

    public long getWriteSkipCount() {
        return this.writeSkipCount;
    }

    public void setWriteSkipCount(int writeSkipCount) {
        this.writeSkipCount = writeSkipCount;
    }

    public long getProcessSkipCount() {
        return this.processSkipCount;
    }

    public void setProcessSkipCount(int processSkipCount) {
        this.processSkipCount = processSkipCount;
    }

    public LocalDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(LocalDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public List<Throwable> getFailureExceptions() {
        return this.failureExceptions;
    }

    public long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StepExecution) || this.getId() == null) {
            return super.equals(obj);
        }
        StepExecution other = (StepExecution)obj;
        return this.stepName.equals(other.getStepName()) && this.jobExecutionId == other.getJobExecutionId() && this.getId().equals(other.getId());
    }

    public int hashCode() {
        Long jobExecutionId = this.getJobExecutionId();
        Long id = this.getId();
        return super.hashCode() + 31 * (this.stepName != null ? this.stepName.hashCode() : 0) + 91 * (jobExecutionId != null ? ((Object)jobExecutionId).hashCode() : 0) + 59 * (id != null ? id.hashCode() : 0);
    }

    public String toString() {
        return String.format(this.getSummary() + ", exitDescription=%s", this.exitStatus.getExitDescription());
    }

    public String getSummary() {
        return super.toString() + String.format(", name=%s, status=%s, exitStatus=%s, readCount=%d, filterCount=%d, writeCount=%d readSkipCount=%d, writeSkipCount=%d, processSkipCount=%d, commitCount=%d, rollbackCount=%d", this.stepName, this.status, this.exitStatus.getExitCode(), this.readCount, this.filterCount, this.writeCount, this.readSkipCount, this.writeSkipCount, this.processSkipCount, this.commitCount, this.rollbackCount);
    }
}

