/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class EventEmittingItemWriteListener
implements ItemWriteListener {
    private static final Log logger = LogFactory.getLog(EventEmittingItemWriteListener.class);
    private MessagePublisher<String> messagePublisher;

    public EventEmittingItemWriteListener(MessageChannel output) {
        Assert.notNull((Object)output, (String)"An output channel is required");
        this.messagePublisher = new MessagePublisher(output);
    }

    public void beforeWrite(List items) {
        this.messagePublisher.publish(items.size() + " items to be written.");
    }

    public void afterWrite(List items) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing afterWrite: " + items));
        }
        this.messagePublisher.publish(items.size() + " items have been written.");
    }

    public void onWriteError(Exception exception, List items) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onWriteError: " + exception.getMessage()), (Throwable)exception);
        }
        String payload = "Exception while " + items.size() + " items are attempted to be written.";
        this.messagePublisher.publishWithThrowableHeader(payload, exception.getMessage());
    }
}

