/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class EventEmittingItemReadListener
implements ItemReadListener {
    private static final Log logger = LogFactory.getLog(EventEmittingItemReadListener.class);
    private MessagePublisher<String> messagePublisher;

    public EventEmittingItemReadListener(MessageChannel output) {
        Assert.notNull((Object)output, (String)"An output channel is required");
        this.messagePublisher = new MessagePublisher(output);
    }

    public void beforeRead() {
    }

    public void afterRead(Object item) {
    }

    public void onReadError(Exception ex) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onReadError: " + ex.getMessage()), (Throwable)ex);
        }
        this.messagePublisher.publishWithThrowableHeader("Exception while item was being read", ex.getMessage());
    }
}

