/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.batch.core.JobExecution;
import org.springframework.cloud.task.batch.listener.TaskBatchDao;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.util.Assert;

public class MapTaskBatchDao
implements TaskBatchDao {
    private Map<Long, Set<Long>> relationships;

    public MapTaskBatchDao(Map<Long, Set<Long>> relationships) {
        Assert.notNull(relationships, (String)"Relationships must not be null");
        this.relationships = relationships;
    }

    @Override
    public void saveRelationship(TaskExecution taskExecution, JobExecution jobExecution) {
        Assert.notNull((Object)taskExecution, (String)"A taskExecution is required");
        Assert.notNull((Object)jobExecution, (String)"A jobExecution is required");
        if (this.relationships.containsKey(taskExecution.getExecutionId())) {
            this.relationships.get(taskExecution.getExecutionId()).add(jobExecution.getId());
        } else {
            TreeSet<Long> jobExecutionIds = new TreeSet<Long>();
            jobExecutionIds.add(jobExecution.getId());
            this.relationships.put(taskExecution.getExecutionId(), jobExecutionIds);
        }
    }
}

