/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.partition;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.integration.partition.BeanFactoryStepLocator;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class DeployerStepExecutionHandler
implements CommandLineRunner {
    private JobExplorer jobExplorer;
    private JobRepository jobRepository;
    private Log logger = LogFactory.getLog(DeployerStepExecutionHandler.class);
    @Autowired
    private Environment environment;
    private StepLocator stepLocator;

    public DeployerStepExecutionHandler(BeanFactory beanFactory, JobExplorer jobExplorer, JobRepository jobRepository) {
        Assert.notNull((Object)beanFactory, (String)"A beanFactory is required");
        Assert.notNull((Object)jobExplorer, (String)"A jobExplorer is required");
        Assert.notNull((Object)jobRepository, (String)"A jobRepository is required");
        this.stepLocator = new BeanFactoryStepLocator();
        ((BeanFactoryStepLocator)this.stepLocator).setBeanFactory(beanFactory);
        this.jobExplorer = jobExplorer;
        this.jobRepository = jobRepository;
    }

    public void run(String ... args) throws Exception {
        this.validateRequest();
        Long jobExecutionId = Long.parseLong(this.environment.getProperty("spring.cloud.task.job-execution-id"));
        Long stepExecutionId = Long.parseLong(this.environment.getProperty("spring.cloud.task.step-execution-id"));
        StepExecution stepExecution = this.jobExplorer.getStepExecution(jobExecutionId, stepExecutionId);
        if (stepExecution == null) {
            throw new NoSuchStepException(String.format("No StepExecution could be located for step execution id %s within job execution %s", stepExecutionId, jobExecutionId));
        }
        String stepName = this.environment.getProperty("spring.cloud.task.step-name");
        Step step = this.stepLocator.getStep(stepName);
        try {
            this.logger.debug((Object)String.format("Executing step %s with step execution id %s and job execution id %s", stepExecution.getStepName(), stepExecutionId, jobExecutionId));
            step.execute(stepExecution);
        }
        catch (JobInterruptedException e) {
            stepExecution.setStatus(BatchStatus.STOPPED);
            this.jobRepository.update(stepExecution);
        }
        catch (Throwable e) {
            stepExecution.addFailureException(e);
            stepExecution.setStatus(BatchStatus.FAILED);
            this.jobRepository.update(stepExecution);
        }
    }

    private void validateRequest() {
        Assert.isTrue((boolean)this.environment.containsProperty("spring.cloud.task.job-execution-id"), (String)"A job execution id is required");
        Assert.isTrue((boolean)this.environment.containsProperty("spring.cloud.task.step-execution-id"), (String)"A step execution id is required");
        Assert.isTrue((boolean)this.environment.containsProperty("spring.cloud.task.step-name"), (String)"A step name is required");
        Assert.isTrue((boolean)this.stepLocator.getStepNames().contains(this.environment.getProperty("spring.cloud.task.step-name")), (String)"The step requested cannot be found in the provided BeanFactory");
    }
}

