/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import javax.sql.DataSource;
import org.springframework.batch.core.JobExecution;
import org.springframework.cloud.task.batch.listener.TaskBatchDao;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcTaskBatchDao
implements TaskBatchDao {
    private String tablePrefix = "TASK_";
    private static final String INSERT_STATEMENT = "INSERT INTO %PREFIX%TASK_BATCH VALUES(?, ?)";
    private JdbcOperations jdbcTemplate;

    public JdbcTaskBatchDao(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"A dataSource is required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public void saveRelationship(TaskExecution taskExecution, JobExecution jobExecution) {
        Assert.notNull((Object)taskExecution, (String)"A taskExecution is required");
        Assert.notNull((Object)jobExecution, (String)"A jobExecution is required");
        this.jdbcTemplate.update(this.getQuery(INSERT_STATEMENT), new Object[]{taskExecution.getExecutionId(), jobExecution.getId()});
    }

    public void setTablePrefix(String tablePrefix) {
        Assert.notNull((Object)tablePrefix, (String)"Null is not allowed as a tablePrefix (use an empty string if you don't want a prefix at all).");
        this.tablePrefix = tablePrefix;
    }

    private String getQuery(String base) {
        return StringUtils.replace((String)base, (String)"%PREFIX%", (String)this.tablePrefix);
    }
}

