/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.partition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.poller.DirectPoller;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.task.listener.annotation.BeforeTask;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DeployerPartitionHandler
implements PartitionHandler,
EnvironmentAware {
    public static final String SPRING_CLOUD_TASK_JOB_EXECUTION_ID = "spring.cloud.task.job-execution-id";
    public static final String SPRING_CLOUD_TASK_STEP_EXECUTION_ID = "spring.cloud.task.step-execution-id";
    public static final String SPRING_CLOUD_TASK_STEP_NAME = "spring.cloud.task.step-name";
    private int maxWorkers = -1;
    private int gridSize = 1;
    private int currentWorkers = 0;
    private TaskLauncher taskLauncher;
    private JobExplorer jobExplorer;
    private TaskExecution taskExecution;
    private Resource resource;
    private Map<String, String> environmentProperties = new HashMap<String, String>();
    private String stepName;
    private Log logger = LogFactory.getLog(DeployerPartitionHandler.class);
    private long pollInterval = 10000L;
    private long timeout = -1L;
    private Environment environment;

    public DeployerPartitionHandler(TaskLauncher taskLauncher, JobExplorer jobExplorer, Resource resource, String stepName) {
        Assert.notNull((Object)taskLauncher, (String)"A taskLauncher is required");
        Assert.notNull((Object)jobExplorer, (String)"A jobExplorer is required");
        Assert.notNull((Object)resource, (String)"A resource is required");
        Assert.hasText((String)stepName, (String)"A step name is required");
        this.taskLauncher = taskLauncher;
        this.jobExplorer = jobExplorer;
        this.resource = resource;
        this.stepName = stepName;
    }

    public void setMaxWorkers(int maxWorkers) {
        Assert.isTrue((maxWorkers != 0 ? 1 : 0) != 0, (String)"maxWorkers cannot be 0");
        this.maxWorkers = maxWorkers;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setEnvironmentProperties(Map<String, String> environmentProperties) {
        this.environmentProperties = environmentProperties;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @BeforeTask
    public void beforeTask(TaskExecution taskExecution) {
        this.taskExecution = taskExecution;
    }

    public Collection<StepExecution> handle(StepExecutionSplitter stepSplitter, StepExecution stepExecution) throws Exception {
        Set tempCandidates = stepSplitter.split(stepExecution, this.gridSize);
        HashSet<StepExecution> candidates = new HashSet<StepExecution>(tempCandidates.size());
        candidates.addAll(tempCandidates);
        int partitions = candidates.size();
        this.logger.debug((Object)String.format("%s partitions were returned", partitions));
        HashSet<StepExecution> executed = new HashSet<StepExecution>(candidates.size());
        if (CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        this.launchWorkers(candidates, executed);
        candidates.removeAll(executed);
        return this.pollReplies(stepExecution, executed, candidates, partitions);
    }

    private void launchWorkers(Set<StepExecution> candidates, Set<StepExecution> executed) {
        for (StepExecution execution : candidates) {
            if (this.currentWorkers >= this.maxWorkers && this.maxWorkers >= 0) continue;
            this.launchWorker(execution);
            ++this.currentWorkers;
            executed.add(execution);
        }
    }

    private void launchWorker(StepExecution workerStepExecution) {
        Map<String, String> arguments = this.getArguments(this.taskExecution.getArguments());
        arguments.put(SPRING_CLOUD_TASK_JOB_EXECUTION_ID, String.valueOf(workerStepExecution.getJobExecution().getId()));
        arguments.put(SPRING_CLOUD_TASK_STEP_EXECUTION_ID, String.valueOf(workerStepExecution.getId()));
        arguments.put(SPRING_CLOUD_TASK_STEP_NAME, this.stepName);
        AppDefinition definition = new AppDefinition(String.format("%s:%s:%s", this.taskExecution.getTaskName(), workerStepExecution.getJobExecution().getJobInstance().getJobName(), workerStepExecution.getStepName()), arguments);
        HashMap<String, String> environmentProperties = new HashMap<String, String>(this.environmentProperties.size());
        environmentProperties.putAll(this.getCurrentEnvironmentProperties());
        environmentProperties.putAll(this.environmentProperties);
        AppDeploymentRequest request = new AppDeploymentRequest(definition, this.resource, environmentProperties);
        this.taskLauncher.launch(request);
    }

    private Collection<StepExecution> pollReplies(final StepExecution masterStepExecution, final Set<StepExecution> executed, final Set<StepExecution> candidates, final int size) throws Exception {
        final ArrayList result = new ArrayList(executed.size());
        Callable<Collection<StepExecution>> callback = new Callable<Collection<StepExecution>>(){

            @Override
            public Collection<StepExecution> call() throws Exception {
                HashSet newExecuted = new HashSet();
                for (StepExecution curStepExecution : executed) {
                    StepExecution partitionStepExecution;
                    if (result.contains(curStepExecution) || !DeployerPartitionHandler.this.isComplete((partitionStepExecution = DeployerPartitionHandler.this.jobExplorer.getStepExecution(masterStepExecution.getJobExecutionId(), curStepExecution.getId())).getStatus())) continue;
                    result.add(partitionStepExecution);
                    DeployerPartitionHandler.this.currentWorkers--;
                    if (candidates.isEmpty()) continue;
                    DeployerPartitionHandler.this.launchWorkers(candidates, newExecuted);
                    candidates.removeAll(newExecuted);
                }
                executed.addAll(newExecuted);
                if (result.size() == size) {
                    return result;
                }
                return null;
            }
        };
        DirectPoller poller = new DirectPoller(this.pollInterval);
        Future resultsFuture = poller.poll((Callable)callback);
        if (this.timeout >= 0L) {
            return (Collection)resultsFuture.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        return (Collection)resultsFuture.get();
    }

    private boolean isComplete(BatchStatus status) {
        return status.equals((Object)BatchStatus.COMPLETED) || status.isGreaterThan(BatchStatus.STARTED);
    }

    private Map<String, String> getArguments(List<String> arguments) {
        HashMap<String, String> argumentMap = new HashMap<String, String>(arguments.size());
        for (String argument : arguments) {
            String[] pieces = argument.split("=");
            argumentMap.put(pieces[0], pieces[1]);
        }
        return argumentMap;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private Map<String, String> getCurrentEnvironmentProperties() {
        HashMap<String, String> currentEnvironment = new HashMap<String, String>();
        HashSet<String> keys = new HashSet<String>();
        for (PropertySource propertySource : ((AbstractEnvironment)this.environment).getPropertySources()) {
            if (!(propertySource instanceof MapPropertySource)) continue;
            keys.addAll(Arrays.asList(((MapPropertySource)propertySource).getPropertyNames()));
        }
        for (String key : keys) {
            currentEnvironment.put(key, this.environment.getProperty(key));
        }
        return currentEnvironment;
    }
}

