/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.configuration;

import java.lang.reflect.Field;
import javax.sql.DataSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.task.batch.listener.TaskBatchExecutionListener;
import org.springframework.cloud.task.batch.listener.support.JdbcTaskBatchDao;
import org.springframework.cloud.task.batch.listener.support.MapTaskBatchDao;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.cloud.task.repository.dao.MapTaskExecutionDao;
import org.springframework.cloud.task.repository.support.SimpleTaskExplorer;
import org.springframework.util.ReflectionUtils;

public class TaskBatchExecutionListenerFactoryBean
implements FactoryBean<TaskBatchExecutionListener> {
    private TaskBatchExecutionListener listener;
    private DataSource dataSource;
    private TaskExplorer taskExplorer;

    public TaskBatchExecutionListenerFactoryBean(DataSource dataSource, TaskExplorer taskExplorer) {
        this.dataSource = dataSource;
        this.taskExplorer = taskExplorer;
    }

    public TaskBatchExecutionListener getObject() throws Exception {
        if (this.listener != null) {
            return this.listener;
        }
        this.listener = this.dataSource == null ? new TaskBatchExecutionListener(this.getMapTaskBatchDao()) : new TaskBatchExecutionListener(new JdbcTaskBatchDao(this.dataSource));
        return this.listener;
    }

    public Class<?> getObjectType() {
        return TaskBatchExecutionListener.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private MapTaskBatchDao getMapTaskBatchDao() throws Exception {
        MapTaskExecutionDao taskExecutionDao;
        Field taskExecutionDaoField = ReflectionUtils.findField(SimpleTaskExplorer.class, (String)"taskExecutionDao");
        taskExecutionDaoField.setAccessible(true);
        if (AopUtils.isJdkDynamicProxy((Object)this.taskExplorer)) {
            SimpleTaskExplorer dereferencedTaskRepository = (SimpleTaskExplorer)((Advised)this.taskExplorer).getTargetSource().getTarget();
            taskExecutionDao = (MapTaskExecutionDao)ReflectionUtils.getField((Field)taskExecutionDaoField, (Object)dereferencedTaskRepository);
        } else {
            taskExecutionDao = (MapTaskExecutionDao)ReflectionUtils.getField((Field)taskExecutionDaoField, (Object)this.taskExplorer);
        }
        return new MapTaskBatchDao(taskExecutionDao.getBatchJobAssociations());
    }
}

