/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.CompositeHealthContributor;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.HealthContributors;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.DefaultBinderFactory;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(name={"org.springframework.boot.health.contributor.HealthIndicator"})
@ConditionalOnEnabledHealthIndicator(value="binders")
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
@ConditionalOnBean(value={BinderFactory.class})
@AutoConfigureAfter(value={BindingServiceConfiguration.class})
@AutoConfiguration
public class BindersHealthIndicatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public BindersHealthContributor bindersHealthContributor() {
        return new BindersHealthContributor();
    }

    @Bean
    public DefaultBinderFactory.Listener bindersHealthIndicatorListener(BindersHealthContributor bindersHealthContributor) {
        return new BindersHealthIndicatorListener(bindersHealthContributor);
    }

    public static class BindersHealthContributor
    implements CompositeHealthContributor {
        private static final HealthIndicator UNKNOWN = () -> Health.unknown().build();
        private volatile Map<String, HealthContributor> contributors = Collections.emptyMap();
        private final ReentrantLock lock = new ReentrantLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(String binderConfigurationName, Map<String, HealthContributor> binderHealthContributors) {
            this.lock.lock();
            try {
                LinkedHashMap<String, HealthContributor> newContributors = new LinkedHashMap<String, HealthContributor>(this.contributors);
                HealthContributor contributor = this.obtainContributor(binderHealthContributors);
                newContributors.put(binderConfigurationName, contributor);
                this.contributors = newContributors;
            }
            finally {
                this.lock.unlock();
            }
        }

        private HealthContributor obtainContributor(Map<String, HealthContributor> binderHealthContributors) {
            if (binderHealthContributors.isEmpty()) {
                return UNKNOWN;
            }
            if (binderHealthContributors.size() == 1) {
                return binderHealthContributors.values().iterator().next();
            }
            return CompositeHealthContributor.fromMap(binderHealthContributors);
        }

        public HealthContributor getContributor(String name) {
            return this.contributors.get(name);
        }

        public Stream<HealthContributors.Entry> stream() {
            return this.contributors.entrySet().stream().map(entry -> new HealthContributors.Entry((String)entry.getKey(), (HealthContributor)entry.getValue()));
        }
    }

    public static class BindersHealthIndicatorListener
    implements DefaultBinderFactory.Listener {
        private final BindersHealthContributor bindersHealthContributor;

        BindersHealthIndicatorListener(BindersHealthContributor bindersHealthContributor) {
            this.bindersHealthContributor = bindersHealthContributor;
        }

        @Override
        public void afterBinderContextInitialized(String binderConfigurationName, ConfigurableApplicationContext binderContext) {
            if (this.bindersHealthContributor != null) {
                this.bindersHealthContributor.add(binderConfigurationName, binderContext.getBeansOfType(HealthContributor.class));
            }
        }
    }
}

