/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.config.MeterFilter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.cloud.stream.micrometer.ApplicationMetricsProperties;
import org.springframework.cloud.stream.micrometer.DefaultDestinationPublishingMeterRegistry;
import org.springframework.cloud.stream.micrometer.MetersPublisherBinding;
import org.springframework.cloud.stream.micrometer.MetricsPublisherConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnClass(value={Binder.class, MetricsAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.stream.bindings.applicationMetrics.destination"})
@EnableConfigurationProperties(value={ApplicationMetricsProperties.class})
public class DestinationPublishingMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MetricsPublisherConfig metricsPublisherConfig(ApplicationMetricsProperties metersPublisherProperties) {
        return new MetricsPublisherConfig(metersPublisherProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultDestinationPublishingMeterRegistry defaultDestinationPublishingMeterRegistry(ApplicationMetricsProperties applicationMetricsProperties, MetersPublisherBinding publisherBinding, MetricsPublisherConfig metricsPublisherConfig, Clock clock) {
        DefaultDestinationPublishingMeterRegistry registry = new DefaultDestinationPublishingMeterRegistry(applicationMetricsProperties, publisherBinding, metricsPublisherConfig, clock);
        if (StringUtils.hasText((String)applicationMetricsProperties.getMeterFilter())) {
            registry.config().meterFilter(MeterFilter.denyUnless(id -> PatternMatchUtils.simpleMatch((String)applicationMetricsProperties.getMeterFilter(), (String)id.getName())));
        }
        return registry;
    }

    @Bean
    public BeanFactoryPostProcessor metersPublisherBindingRegistrant() {
        return new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                RootBeanDefinition emitterBindingDefinition = new RootBeanDefinition(BindableProxyFactory.class);
                emitterBindingDefinition.getConstructorArgumentValues().addGenericArgumentValue(MetersPublisherBinding.class);
                ((DefaultListableBeanFactory)beanFactory).registerBeanDefinition(MetersPublisherBinding.class.getName(), (BeanDefinition)emitterBindingDefinition);
            }
        };
    }
}

