/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.PartitionAwareFunctionWrapper;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public final class StreamBridge
implements SmartInitializingSingleton {
    private static String STREAM_BRIDGE_FUNC_NAME = "streamBridge";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, SubscribableChannel> channelCache;
    private final FunctionCatalog functionCatalog;
    private final FunctionRegistry functionRegistry;
    private final BinderAwareChannelResolver.NewDestinationBindingCallback destinationBindingCallback;
    private BindingServiceProperties bindingServiceProperties;
    private ConfigurableApplicationContext applicationContext;
    private boolean initialized;
    @Autowired
    private BindingService bindingService;

    StreamBridge(FunctionCatalog functionCatalog, FunctionRegistry functionRegistry, final BindingServiceProperties bindingServiceProperties, ConfigurableApplicationContext applicationContext, @Nullable BinderAwareChannelResolver.NewDestinationBindingCallback destinationBindingCallback) {
        this.functionCatalog = functionCatalog;
        this.functionRegistry = functionRegistry;
        this.applicationContext = applicationContext;
        this.bindingServiceProperties = bindingServiceProperties;
        this.destinationBindingCallback = destinationBindingCallback;
        this.channelCache = new LinkedHashMap<String, SubscribableChannel>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, SubscribableChannel> eldest) {
                boolean remove;
                boolean bl = remove = this.size() > bindingServiceProperties.getDynamicDestinationCacheSize();
                if (remove && StreamBridge.this.logger.isDebugEnabled()) {
                    StreamBridge.this.logger.debug((Object)("Removing message channel from cache " + eldest.getKey()));
                }
                return remove;
            }
        };
    }

    public boolean send(String bindingName, Object data) {
        return this.send(bindingName, data, MimeTypeUtils.APPLICATION_JSON);
    }

    public boolean send(String bindingName, Object data, MimeType outputContentType) {
        Function functionToInvoke;
        if (!(data instanceof Message)) {
            data = MessageBuilder.withPayload((Object)data).build();
        }
        ProducerProperties producerProperties = this.bindingServiceProperties.getProducerProperties(bindingName);
        SubscribableChannel messageChannel = this.resolveDestination(bindingName, producerProperties);
        boolean skipConversion = producerProperties.isUseNativeEncoding();
        Function function = functionToInvoke = skipConversion ? v -> v instanceof Message ? v : MessageBuilder.withPayload((Object)v).build() : (Function)this.functionCatalog.lookup(STREAM_BRIDGE_FUNC_NAME, new String[]{outputContentType.toString()});
        if (producerProperties != null && producerProperties.isPartitioned()) {
            functionToInvoke = new PartitionAwareFunctionWrapper((SimpleFunctionRegistry.FunctionInvocationWrapper)functionToInvoke, this.applicationContext, producerProperties);
        }
        Message resultMessage = (Message)functionToInvoke.apply((Object)data);
        return messageChannel.send(resultMessage);
    }

    public void afterSingletonsInstantiated() {
        if (this.initialized) {
            return;
        }
        FunctionRegistration fr = new FunctionRegistration(v -> v, new String[]{STREAM_BRIDGE_FUNC_NAME});
        this.functionRegistry.register(fr.type(FunctionType.from(Object.class).to(Object.class).message()));
        Map channels = this.applicationContext.getBeansOfType(DirectWithAttributesChannel.class);
        for (Map.Entry channelEntry : channels.entrySet()) {
            if (!((DirectWithAttributesChannel)((Object)channelEntry.getValue())).getAttribute("type").equals("output")) continue;
            this.channelCache.put((String)channelEntry.getKey(), (SubscribableChannel)channelEntry.getValue());
        }
        this.initialized = true;
    }

    synchronized SubscribableChannel resolveDestination(String destinationName, ProducerProperties producerProperties) {
        Object messageChannel = this.channelCache.get(destinationName);
        if (messageChannel == null && this.applicationContext.containsBean(destinationName)) {
            messageChannel = (SubscribableChannel)this.applicationContext.getBean(destinationName, SubscribableChannel.class);
            this.addInterceptors((AbstractMessageChannel)messageChannel);
        }
        if (messageChannel == null) {
            messageChannel = new DirectWithAttributesChannel();
            if (this.destinationBindingCallback != null) {
                Object extendedProducerProperties = this.bindingService.getExtendedProducerProperties(messageChannel, destinationName);
                this.destinationBindingCallback.configure(destinationName, (MessageChannel)messageChannel, producerProperties, extendedProducerProperties);
            }
            this.bindingService.bindProducer(messageChannel, destinationName, false);
            this.channelCache.put(destinationName, (SubscribableChannel)messageChannel);
            this.addInterceptors((AbstractMessageChannel)messageChannel);
        }
        return messageChannel;
    }

    private void addInterceptors(AbstractMessageChannel messageChannel) {
        String[] interceptorNames = this.applicationContext.getBeanNamesForType(ChannelInterceptor.class);
        List interceptors = messageChannel.getInterceptors();
        for (String interceptorName : interceptorNames) {
            ChannelInterceptor interceptor = (ChannelInterceptor)this.applicationContext.getBean(interceptorName, ChannelInterceptor.class);
            if (CollectionUtils.containsInstance((Collection)interceptors, (Object)interceptor)) continue;
            messageChannel.addInterceptor(interceptor);
        }
    }
}

