/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.binding.OutputBindingLifecycle;
import org.springframework.util.Assert;

public class BindingsLifecycleController {
    private final List<InputBindingLifecycle> inputBindingLifecycles;
    private final List<OutputBindingLifecycle> outputBindingsLifecycles;
    private final ObjectMapper objectMapper;

    public BindingsLifecycleController(List<InputBindingLifecycle> inputBindingLifecycles, List<OutputBindingLifecycle> outputBindingsLifecycles) {
        Assert.notEmpty(inputBindingLifecycles, (String)"'inputBindingLifecycles' must not be null or empty");
        this.inputBindingLifecycles = inputBindingLifecycles;
        this.outputBindingsLifecycles = outputBindingsLifecycles;
        this.objectMapper = new ObjectMapper();
    }

    public void stop(String bindingName) {
        this.changeState(bindingName, State.STOPPED);
    }

    public void start(String bindingName) {
        this.changeState(bindingName, State.STARTED);
    }

    public void pause(String bindingName) {
        this.changeState(bindingName, State.PAUSED);
    }

    public void resume(String bindingName) {
        this.changeState(bindingName, State.RESUMED);
    }

    public void changeState(String bindingName, State state) {
        Binding<?> binding = this.locateBinding(bindingName);
        if (binding != null) {
            switch (state) {
                case STARTED: {
                    binding.start();
                    break;
                }
                case STOPPED: {
                    binding.stop();
                    break;
                }
                case PAUSED: {
                    binding.pause();
                    break;
                }
                case RESUMED: {
                    binding.resume();
                    break;
                }
            }
        }
    }

    public List<Binding<?>> queryStates() {
        ArrayList bindings = new ArrayList(this.gatherInputBindings());
        bindings.addAll(this.gatherOutputBindings());
        return (List)this.objectMapper.convertValue(bindings, List.class);
    }

    public Binding<?> queryState(String name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        return this.locateBinding(name);
    }

    private List<Binding<?>> gatherInputBindings() {
        ArrayList inputBindings = new ArrayList();
        for (InputBindingLifecycle inputBindingLifecycle : this.inputBindingLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("inputBindings");
            inputBindings.addAll(lifecycleInputBindings);
        }
        return inputBindings;
    }

    private List<Binding<?>> gatherOutputBindings() {
        ArrayList outputBindings = new ArrayList();
        for (OutputBindingLifecycle inputBindingLifecycle : this.outputBindingsLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("outputBindings");
            outputBindings.addAll(lifecycleInputBindings);
        }
        return outputBindings;
    }

    private Binding<?> locateBinding(String name) {
        Stream bindings = Stream.concat(this.gatherInputBindings().stream(), this.gatherOutputBindings().stream());
        return bindings.filter(binding -> name.equals(binding.getBindingName())).findFirst().orElse(null);
    }

    public static enum State {
        STARTED,
        STOPPED,
        PAUSED,
        RESUMED;

    }
}

