/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.annotation.StreamRetryTemplate;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractBinder<T, C extends ConsumerProperties, P extends ProducerProperties>
implements ApplicationContextAware,
InitializingBean,
Binder<T, C, P> {
    private static final String GROUP_INDEX_DELIMITER = ".";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile GenericApplicationContext applicationContext;
    private volatile EvaluationContext evaluationContext;
    @Autowired(required=false)
    @StreamRetryTemplate
    private Map<String, RetryTemplate> consumerBindingRetryTemplates;

    public static String applyPrefix(String prefix, String name) {
        return prefix + name;
    }

    public static String constructDLQName(String name) {
        return name + ".dlq";
    }

    protected AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isInstanceOf(GenericApplicationContext.class, (Object)applicationContext);
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.applicationContext.getBeanFactory();
    }

    protected EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    public final void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.applicationContext, (String)"The 'applicationContext' property must not be null");
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        }
        this.onInit();
    }

    protected void onInit() throws Exception {
    }

    @Override
    public final Binding<T> bindConsumer(String name, String group, T target, C properties) {
        if (StringUtils.isEmpty((Object)group)) {
            Assert.isTrue((!((ConsumerProperties)properties).isPartitioned() ? 1 : 0) != 0, (String)"A consumer group is required for a partitioned subscription");
        }
        return this.doBindConsumer(name, group, target, properties);
    }

    protected abstract Binding<T> doBindConsumer(String var1, String var2, T var3, C var4);

    @Override
    public final Binding<T> bindProducer(String name, T outboundBindTarget, P properties) {
        return this.doBindProducer(name, outboundBindTarget, properties);
    }

    protected abstract Binding<T> doBindProducer(String var1, T var2, P var3);

    protected final String groupedName(String name, String group) {
        return name + GROUP_INDEX_DELIMITER + (StringUtils.hasText((String)group) ? group : "default");
    }

    protected RetryTemplate buildRetryTemplate(ConsumerProperties properties) {
        RetryTemplate rt;
        if (CollectionUtils.isEmpty(this.consumerBindingRetryTemplates)) {
            rt = new RetryTemplate();
            SimpleRetryPolicy retryPolicy = CollectionUtils.isEmpty(properties.getRetryableExceptions()) ? new SimpleRetryPolicy(properties.getMaxAttempts()) : new SimpleRetryPolicy(properties.getMaxAttempts(), properties.getRetryableExceptions(), true, properties.isDefaultRetryable());
            ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
            backOffPolicy.setInitialInterval((long)properties.getBackOffInitialInterval());
            backOffPolicy.setMultiplier(properties.getBackOffMultiplier());
            backOffPolicy.setMaxInterval((long)properties.getBackOffMaxInterval());
            rt.setRetryPolicy((RetryPolicy)retryPolicy);
            rt.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        } else {
            rt = StringUtils.hasText((String)properties.getRetryTemplateName()) ? this.consumerBindingRetryTemplates.get(properties.getRetryTemplateName()) : this.consumerBindingRetryTemplates.values().iterator().next();
        }
        return rt;
    }
}

