/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.stream.binder.test.AbstractDestination;
import org.springframework.messaging.Message;

public class OutputDestination
extends AbstractDestination {
    private BlockingQueue<Message<?>> messages;

    public Message<byte[]> receive(long timeout) {
        try {
            return this.messages.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public Message<byte[]> receive() {
        return this.receive(0L);
    }

    @Override
    void afterChannelIsSet() {
        this.messages = new LinkedTransferQueue();
        this.getChannel().subscribe(message -> this.messages.offer(message));
    }
}

