/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.BinderException;
import org.springframework.cloud.stream.binder.PartitionKeyExtractorStrategy;
import org.springframework.cloud.stream.binder.PartitionSelectorStrategy;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.expression.EvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class PartitionHandler {
    private final ConfigurableListableBeanFactory beanFactory;
    private final EvaluationContext evaluationContext;
    private final PartitionSelectorStrategy partitionSelector;
    private final ProducerProperties producerProperties;

    public PartitionHandler(ConfigurableListableBeanFactory beanFactory, EvaluationContext evaluationContext, PartitionSelectorStrategy partitionSelector, ProducerProperties properties) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
        this.evaluationContext = evaluationContext;
        this.partitionSelector = partitionSelector == null ? new DefaultPartitionSelector() : partitionSelector;
        this.producerProperties = properties;
    }

    public int determinePartition(Message<?> message) {
        Object key = this.extractKey(message);
        int partition = this.producerProperties.getPartitionSelectorClass() != null ? this.invokePartitionSelector(key) : (this.producerProperties.getPartitionSelectorExpression() != null ? ((Integer)this.producerProperties.getPartitionSelectorExpression().getValue(this.evaluationContext, key, Integer.class)).intValue() : this.partitionSelector.selectPartition(key, this.producerProperties.getPartitionCount()));
        return Math.abs(partition % this.producerProperties.getPartitionCount());
    }

    private Object extractKey(Message<?> message) {
        Object key = null;
        if (this.producerProperties.getPartitionKeyExtractorClass() != null) {
            key = this.invokeKeyExtractor(message);
        } else if (this.producerProperties.getPartitionKeyExpression() != null) {
            key = this.producerProperties.getPartitionKeyExpression().getValue(this.evaluationContext, message);
        }
        Assert.notNull((Object)key, (String)"Partition key cannot be null");
        return key;
    }

    private Object invokeKeyExtractor(Message<?> message) {
        PartitionKeyExtractorStrategy strategy = this.getBean(this.producerProperties.getPartitionKeyExtractorClass().getName(), PartitionKeyExtractorStrategy.class);
        return strategy.extractKey(message);
    }

    private int invokePartitionSelector(Object key) {
        PartitionSelectorStrategy strategy = this.getBean(this.producerProperties.getPartitionSelectorClass().getName(), PartitionSelectorStrategy.class);
        return strategy.selectPartition(key, this.producerProperties.getPartitionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getBean(String className, Class<T> type) {
        if (this.beanFactory.containsBean(className)) {
            return (T)this.beanFactory.getBean(className, type);
        }
        PartitionHandler partitionHandler = this;
        synchronized (partitionHandler) {
            Object bean;
            if (this.beanFactory.containsBean(className)) {
                bean = this.beanFactory.getBean(className, type);
            } else {
                Class clazz;
                try {
                    clazz = ClassUtils.forName((String)className, (ClassLoader)this.beanFactory.getBeanClassLoader());
                }
                catch (Exception e) {
                    throw new BinderException("Failed to load class: " + className, e);
                }
                try {
                    bean = clazz.newInstance();
                    Assert.isInstanceOf(type, (Object)bean);
                    this.beanFactory.registerSingleton(className, bean);
                    this.beanFactory.initializeBean(bean, className);
                }
                catch (Exception e) {
                    throw new BinderException("Failed to instantiate class: " + className, e);
                }
            }
            return (T)bean;
        }
    }

    private static class DefaultPartitionSelector
    implements PartitionSelectorStrategy {
        private DefaultPartitionSelector() {
        }

        @Override
        public int selectPartition(Object key, int partitionCount) {
            int hashCode = key.hashCode();
            if (hashCode == Integer.MIN_VALUE) {
                hashCode = 0;
            }
            return Math.abs(hashCode);
        }
    }
}

