/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.avro;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.util.MimeType;

class OriginalContentTypeResolver
implements ContentTypeResolver {
    private ConcurrentMap<String, MimeType> mimeTypeCache = new ConcurrentHashMap<String, MimeType>();

    OriginalContentTypeResolver() {
    }

    public MimeType resolve(MessageHeaders headers) {
        Object contentType = headers.get((Object)"originalContentType") != null ? headers.get((Object)"originalContentType") : headers.get((Object)"contentType");
        MimeType mimeType = null;
        if (contentType instanceof MimeType) {
            mimeType = (MimeType)contentType;
        } else if (contentType instanceof String && (mimeType = (MimeType)this.mimeTypeCache.get(contentType)) == null) {
            String valueAsString = (String)contentType;
            mimeType = MimeType.valueOf((String)valueAsString);
            this.mimeTypeCache.put(valueAsString, mimeType);
        }
        return mimeType;
    }
}

