/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.schema.client.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.schema.client.CachingRegistryClient;
import org.springframework.cloud.stream.schema.client.DefaultSchemaRegistryClient;
import org.springframework.cloud.stream.schema.client.SchemaRegistryClient;
import org.springframework.cloud.stream.schema.client.config.SchemaRegistryClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={SchemaRegistryClientProperties.class})
public class SchemaRegistryClientConfiguration {
    @Autowired
    private SchemaRegistryClientProperties schemaRegistryClientProperties;

    @Bean
    public SchemaRegistryClient schemaRegistryClient() {
        DefaultSchemaRegistryClient defaultSchemaRegistryClient = new DefaultSchemaRegistryClient();
        if (StringUtils.hasText((String)this.schemaRegistryClientProperties.getEndpoint())) {
            defaultSchemaRegistryClient.setEndpoint(this.schemaRegistryClientProperties.getEndpoint());
        }
        SchemaRegistryClient client = this.schemaRegistryClientProperties.isCached() ? new CachingRegistryClient(defaultSchemaRegistryClient) : defaultSchemaRegistryClient;
        return client;
    }
}

