/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive;

import java.io.Closeable;
import org.reactivestreams.Publisher;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.cloud.stream.reactive.PublisherToMessageChannelResultAdapter;
import org.springframework.cloud.stream.reactive.shaded.rx.RxReactiveStreams;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import rx.Observable;

public class ObservableToMessageChannelResultAdapter
implements StreamListenerResultAdapter<Observable<?>, MessageChannel> {
    private PublisherToMessageChannelResultAdapter publisherToMessageChannelResultAdapter;

    public ObservableToMessageChannelResultAdapter(PublisherToMessageChannelResultAdapter publisherToMessageChannelResultAdapter) {
        Assert.notNull((Object)publisherToMessageChannelResultAdapter, (String)"cannot be null");
        this.publisherToMessageChannelResultAdapter = publisherToMessageChannelResultAdapter;
    }

    public boolean supports(Class<?> resultType, Class<?> bindingTarget) {
        return Observable.class.isAssignableFrom(resultType) && MessageChannel.class.isAssignableFrom(bindingTarget);
    }

    public Closeable adapt(Observable<?> streamListenerResult, MessageChannel bindingTarget) {
        Publisher<?> adaptedPublisher = RxReactiveStreams.toPublisher(streamListenerResult);
        return this.publisherToMessageChannelResultAdapter.adapt(adaptedPublisher, bindingTarget);
    }
}

