/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reactive;

import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.reactive.FluxSender;
import org.springframework.util.Assert;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

class DefaultFluxSender
implements FluxSender {
    private Log log = LogFactory.getLog(DefaultFluxSender.class);
    private volatile Disposable disposable;
    private final Consumer<Object> consumer;

    DefaultFluxSender(Consumer<Object> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null");
        this.consumer = consumer;
    }

    @Override
    public Mono<Void> send(Flux<?> flux) {
        MonoProcessor sendResult = MonoProcessor.create();
        this.disposable = flux.doOnError(e -> this.log.error((Object)"Error during processing: ", e)).retry().subscribe(this.consumer, arg_0 -> ((MonoProcessor)sendResult).onError(arg_0), () -> ((MonoProcessor)sendResult).onComplete());
        return sendResult;
    }

    @Override
    public void close() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }
}

