/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.AbstractTestBinder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.Spy;
import org.springframework.cloud.stream.binder.TestUtils;
import org.springframework.cloud.stream.binding.MessageConverterConfigurer;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;

public abstract class AbstractBinderTests<B extends AbstractTestBinder<? extends AbstractBinder<MessageChannel, CP, PP>, CP, PP>, CP extends ConsumerProperties, PP extends ProducerProperties> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected B testBinder;
    protected double timeoutMultiplier = 1.0;

    protected Message<?> receive(PollableChannel channel) {
        return this.receive(channel, 1);
    }

    protected Message<?> receive(PollableChannel channel, int additionalMultiplier) {
        long startTime = System.currentTimeMillis();
        Message receive = channel.receive((long)((int)(1000.0 * this.timeoutMultiplier * (double)additionalMultiplier)));
        long elapsed = System.currentTimeMillis() - startTime;
        this.logger.debug((Object)("receive() took " + elapsed / 1000L + " seconds"));
        return receive;
    }

    @Test
    public void testClean() throws Exception {
        B binder = this.getBinder();
        Binding foo0ProducerBinding = binder.bindProducer("foo.0", (Object)new DirectChannel(), this.createProducerProperties());
        Binding foo0ConsumerBinding = binder.bindConsumer("foo.0", "test", (Object)new DirectChannel(), this.createConsumerProperties());
        Binding foo1ProducerBinding = binder.bindProducer("foo.1", (Object)new DirectChannel(), this.createProducerProperties());
        Binding foo1ConsumerBinding = binder.bindConsumer("foo.1", "test", (Object)new DirectChannel(), this.createConsumerProperties());
        Binding foo2ProducerBinding = binder.bindProducer("foo.2", (Object)new DirectChannel(), this.createProducerProperties());
        foo0ProducerBinding.unbind();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo0ProducerBinding, "lifecycle", Lifecycle.class).isRunning()).isFalse();
        foo0ConsumerBinding.unbind();
        foo1ProducerBinding.unbind();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo0ConsumerBinding, "lifecycle", Lifecycle.class).isRunning()).isFalse();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo1ProducerBinding, "lifecycle", Lifecycle.class).isRunning()).isFalse();
        foo1ConsumerBinding.unbind();
        foo2ProducerBinding.unbind();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo1ConsumerBinding, "lifecycle", Lifecycle.class).isRunning()).isFalse();
        Assertions.assertThat((boolean)TestUtils.getPropertyValue(foo2ProducerBinding, "lifecycle", Lifecycle.class).isRunning()).isFalse();
    }

    @Test
    public void testSendAndReceive() throws Exception {
        B binder = this.getBinder();
        BindingProperties outputBindingProperties = this.createProducerBindingProperties(this.createProducerProperties());
        DirectChannel moduleOutputChannel = this.createBindableChannel("output", outputBindingProperties);
        QueueChannel moduleInputChannel = new QueueChannel();
        Binding producerBinding = binder.bindProducer("foo.0", (Object)moduleOutputChannel, outputBindingProperties.getProducer());
        Binding consumerBinding = binder.bindConsumer("foo.0", "test", (Object)moduleInputChannel, this.createConsumerProperties());
        Message message = MessageBuilder.withPayload((Object)"foo").setHeader("contentType", (Object)"foo/bar").build();
        this.binderBindUnbindLatency();
        moduleOutputChannel.send(message);
        Message<?> inbound = this.receive((PollableChannel)moduleInputChannel);
        Assertions.assertThat(inbound).isNotNull();
        Assertions.assertThat((Object)inbound.getPayload()).isEqualTo((Object)"foo");
        Assertions.assertThat((Object)inbound.getHeaders().get((Object)"originalContentType")).isNull();
        Assertions.assertThat((Object)inbound.getHeaders().get((Object)"contentType")).isEqualTo((Object)"foo/bar");
        producerBinding.unbind();
        consumerBinding.unbind();
    }

    @Test
    public void testSendAndReceiveMultipleTopics() throws Exception {
        B binder = this.getBinder();
        DirectChannel moduleOutputChannel1 = this.createBindableChannel("output1", this.createProducerBindingProperties(this.createProducerProperties()));
        DirectChannel moduleOutputChannel2 = this.createBindableChannel("output2", this.createProducerBindingProperties(this.createProducerProperties()));
        QueueChannel moduleInputChannel = new QueueChannel();
        Binding producerBinding1 = binder.bindProducer("foo.x", (Object)moduleOutputChannel1, this.createProducerProperties());
        Binding producerBinding2 = binder.bindProducer("foo.y", (Object)moduleOutputChannel2, this.createProducerProperties());
        Binding consumerBinding1 = binder.bindConsumer("foo.x", "test", (Object)moduleInputChannel, this.createConsumerProperties());
        Binding consumerBinding2 = binder.bindConsumer("foo.y", "test", (Object)moduleInputChannel, this.createConsumerProperties());
        String testPayload1 = "foo" + UUID.randomUUID().toString();
        Message message1 = MessageBuilder.withPayload((Object)testPayload1.getBytes()).build();
        String testPayload2 = "foo" + UUID.randomUUID().toString();
        Message message2 = MessageBuilder.withPayload((Object)testPayload2.getBytes()).build();
        this.binderBindUnbindLatency();
        moduleOutputChannel1.send(message1);
        moduleOutputChannel2.send(message2);
        Object[] messages = new Message[]{this.receive((PollableChannel)moduleInputChannel), this.receive((PollableChannel)moduleInputChannel)};
        Assertions.assertThat((Object)messages[0]).isNotNull();
        Assertions.assertThat((Object)messages[1]).isNotNull();
        Assertions.assertThat((Object[])messages).extracting("payload").containsExactlyInAnyOrder(new Object[]{testPayload1.getBytes(), testPayload2.getBytes()});
        producerBinding1.unbind();
        producerBinding2.unbind();
        consumerBinding1.unbind();
        consumerBinding2.unbind();
    }

    @Test
    public void testSendAndReceiveNoOriginalContentType() throws Exception {
        B binder = this.getBinder();
        BindingProperties producerBindingProperties = this.createProducerBindingProperties(this.createProducerProperties());
        DirectChannel moduleOutputChannel = this.createBindableChannel("output", producerBindingProperties);
        QueueChannel moduleInputChannel = new QueueChannel();
        Binding producerBinding = binder.bindProducer("bar.0", (Object)moduleOutputChannel, producerBindingProperties.getProducer());
        Binding consumerBinding = binder.bindConsumer("bar.0", "test", (Object)moduleInputChannel, this.createConsumerProperties());
        this.binderBindUnbindLatency();
        Message message = MessageBuilder.withPayload((Object)"foo").build();
        moduleOutputChannel.send(message);
        Message<?> inbound = this.receive((PollableChannel)moduleInputChannel);
        Assertions.assertThat(inbound).isNotNull();
        Assertions.assertThat((Object)inbound.getPayload()).isEqualTo((Object)"foo");
        Assertions.assertThat((Object)inbound.getHeaders().get((Object)"originalContentType")).isNull();
        Assertions.assertThat((Object)inbound.getHeaders().get((Object)"contentType")).isEqualTo((Object)"text/plain");
        producerBinding.unbind();
        consumerBinding.unbind();
    }

    protected abstract B getBinder() throws Exception;

    protected abstract CP createConsumerProperties();

    protected abstract PP createProducerProperties();

    protected final BindingProperties createConsumerBindingProperties(CP consumerProperties) {
        BindingProperties bindingProperties = new BindingProperties();
        bindingProperties.setConsumer(consumerProperties);
        return bindingProperties;
    }

    protected BindingProperties createProducerBindingProperties(PP producerProperties) {
        BindingProperties bindingProperties = new BindingProperties();
        bindingProperties.setProducer(producerProperties);
        return bindingProperties;
    }

    protected DirectChannel createBindableChannel(String channelName, BindingProperties bindingProperties) throws Exception {
        BindingServiceProperties bindingServiceProperties = new BindingServiceProperties();
        bindingServiceProperties.getBindings().put(channelName, bindingProperties);
        GenericApplicationContext applicationContext = new GenericApplicationContext();
        applicationContext.refresh();
        bindingServiceProperties.setApplicationContext((ApplicationContext)applicationContext);
        bindingServiceProperties.setConversionService((ConversionService)new DefaultConversionService());
        bindingServiceProperties.afterPropertiesSet();
        DirectChannel channel = new DirectChannel();
        channel.setBeanName(channelName);
        MessageConverterConfigurer messageConverterConfigurer = new MessageConverterConfigurer(bindingServiceProperties, new CompositeMessageConverterFactory(null, null));
        messageConverterConfigurer.setBeanFactory((BeanFactory)applicationContext.getBeanFactory());
        messageConverterConfigurer.afterPropertiesSet();
        messageConverterConfigurer.configureOutputChannel((MessageChannel)channel, channelName);
        return channel;
    }

    @After
    public void cleanup() {
        if (this.testBinder != null) {
            ((AbstractTestBinder)this.testBinder).cleanup();
        }
    }

    protected void binderBindUnbindLatency() throws InterruptedException {
    }

    public abstract Spy spyOn(String var1);
}

