/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.util.Assert;

public class RabbitExpressionEvaluatingInterceptor
extends ChannelInterceptorAdapter {
    public static final ExpressionParser PARSER = new SpelExpressionParser();
    public static final String ROUTING_KEY_HEADER = "scst_routingKey";
    public static final String DELAY_HEADER = "scst_delay";
    private final Expression routingKeyExpression;
    private final Expression delayExpression;
    private final EvaluationContext evaluationContext;

    public RabbitExpressionEvaluatingInterceptor(String routingKeyExpression, String delayExpression, EvaluationContext evaluationContext) {
        Assert.isTrue((routingKeyExpression != null || delayExpression != null ? 1 : 0) != 0, (String)"At least one expression is required");
        Assert.notNull((Object)evaluationContext, (String)"the 'evaluationContext' cannot be null");
        this.routingKeyExpression = routingKeyExpression != null ? PARSER.parseExpression(routingKeyExpression) : null;
        this.delayExpression = delayExpression != null ? PARSER.parseExpression(delayExpression) : null;
        this.evaluationContext = evaluationContext;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        MessageBuilder builder = MessageBuilder.fromMessage(message);
        if (this.routingKeyExpression != null) {
            builder.setHeader(ROUTING_KEY_HEADER, this.routingKeyExpression.getValue(this.evaluationContext, message));
        }
        if (this.delayExpression != null) {
            builder.setHeader(DELAY_HEADER, this.delayExpression.getValue(this.evaluationContext, message));
        }
        return builder.build();
    }
}

