/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.config;

import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.RabbitHealthIndicator;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.rabbit.config.RabbitMessageChannelBinderConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={RabbitMessageChannelBinderConfiguration.class})
public class RabbitServiceAutoConfiguration {
    @Bean
    public HealthIndicator binderHealthIndicator(RabbitTemplate rabbitTemplate) {
        return new RabbitHealthIndicator(rabbitTemplate);
    }

    @Configuration
    @Profile(value={"!cloud"})
    @Import(value={RabbitAutoConfiguration.class})
    protected static class NoCloudProfile {
        protected NoCloudProfile() {
        }
    }

    @Configuration
    @Profile(value={"cloud"})
    protected static class CloudProfile {
        protected CloudProfile() {
        }

        @Configuration
        @ConditionalOnMissingClass(value={"org.springframework.cloud.Cloud"})
        @Import(value={RabbitAutoConfiguration.class})
        protected static class NoCloudConnectors {
            protected NoCloudConnectors() {
            }
        }

        @Configuration
        @ConditionalOnClass(value={Cloud.class})
        protected static class CloudConnectors {
            protected CloudConnectors() {
            }

            @Bean
            public Cloud cloud() {
                return new CloudFactory().getCloud();
            }

            @Configuration
            @ConditionalOnProperty(value={"spring.cloud.stream.overrideCloudConnectors"})
            @Import(value={RabbitAutoConfiguration.class})
            protected static class OverrideCloudConnectors {
                protected OverrideCloudConnectors() {
                }
            }

            @Configuration
            @ConditionalOnProperty(value={"spring.cloud.stream.overrideCloudConnectors"}, havingValue="false", matchIfMissing=true)
            @EnableConfigurationProperties(value={RabbitProperties.class})
            protected static class UseCloudConnectors {
                protected UseCloudConnectors() {
                }

                @Bean
                ConnectionFactory rabbitConnectionFactory(Cloud cloud) {
                    return (ConnectionFactory)cloud.getSingletonServiceConnector(ConnectionFactory.class, null);
                }

                @Bean
                @ConditionalOnMissingBean(value={RabbitTemplate.class})
                RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
                    return new RabbitTemplate(connectionFactory);
                }
            }
        }
    }
}

