/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.config;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.io.IOException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.StreamMessageConverter;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.kafka.KafkaBinderMetrics;
import org.springframework.cloud.stream.binder.kafka.KafkaBindingRebalanceListener;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.cloud.stream.binder.kafka.KafkaNullConverter;
import org.springframework.cloud.stream.binder.kafka.config.ClientFactoryCustomizer;
import org.springframework.cloud.stream.binder.kafka.config.KafkaBinderHealthIndicatorConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.JaasLoginModuleConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.cloud.stream.binder.kafka.utils.DlqPartitionFunction;
import org.springframework.cloud.stream.config.ConsumerEndpointCustomizer;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.MessageSourceCustomizer;
import org.springframework.cloud.stream.config.ProducerMessageHandlerCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.kafka.inbound.KafkaMessageDrivenChannelAdapter;
import org.springframework.integration.kafka.inbound.KafkaMessageSource;
import org.springframework.integration.kafka.outbound.KafkaProducerMessageHandler;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.MicrometerConsumerListener;
import org.springframework.kafka.core.MicrometerProducerListener;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.security.jaas.KafkaJaasLoginModuleInitializer;
import org.springframework.kafka.support.LoggingProducerListener;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.MessageConverter;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={KafkaAutoConfiguration.class, KafkaBinderHealthIndicatorConfiguration.class})
@EnableConfigurationProperties(value={KafkaExtendedBindingProperties.class})
public class KafkaBinderConfiguration {
    @Autowired
    private KafkaExtendedBindingProperties kafkaExtendedBindingProperties;
    @Autowired
    private ProducerListener producerListener;
    @Autowired
    private KafkaProperties kafkaProperties;

    @Bean
    KafkaBinderConfigurationProperties configurationProperties(KafkaProperties kafkaProperties) {
        return new KafkaBinderConfigurationProperties(kafkaProperties);
    }

    @Bean
    KafkaTopicProvisioner provisioningProvider(KafkaBinderConfigurationProperties configurationProperties) {
        return new KafkaTopicProvisioner(configurationProperties, this.kafkaProperties);
    }

    @Bean
    KafkaMessageChannelBinder kafkaMessageChannelBinder(KafkaBinderConfigurationProperties configurationProperties, KafkaTopicProvisioner provisioningProvider, @Nullable ListenerContainerCustomizer<AbstractMessageListenerContainer<?, ?>> listenerContainerCustomizer, @Nullable MessageSourceCustomizer<KafkaMessageSource<?, ?>> sourceCustomizer, @Nullable ProducerMessageHandlerCustomizer<KafkaProducerMessageHandler<?, ?>> messageHandlerCustomizer, @Nullable ConsumerEndpointCustomizer<KafkaMessageDrivenChannelAdapter<?, ?>> consumerCustomizer, ObjectProvider<KafkaBindingRebalanceListener> rebalanceListener, ObjectProvider<DlqPartitionFunction> dlqPartitionFunction, ObjectProvider<ClientFactoryCustomizer> clientFactoryCustomizer) {
        KafkaMessageChannelBinder kafkaMessageChannelBinder = new KafkaMessageChannelBinder(configurationProperties, provisioningProvider, listenerContainerCustomizer, sourceCustomizer, (KafkaBindingRebalanceListener)rebalanceListener.getIfUnique(), (DlqPartitionFunction)dlqPartitionFunction.getIfUnique());
        kafkaMessageChannelBinder.setProducerListener((ProducerListener<byte[], byte[]>)this.producerListener);
        kafkaMessageChannelBinder.setExtendedBindingProperties(this.kafkaExtendedBindingProperties);
        kafkaMessageChannelBinder.setProducerMessageHandlerCustomizer(messageHandlerCustomizer);
        kafkaMessageChannelBinder.setConsumerEndpointCustomizer(consumerCustomizer);
        kafkaMessageChannelBinder.setClientFactoryCustomizer((ClientFactoryCustomizer)clientFactoryCustomizer.getIfUnique());
        return kafkaMessageChannelBinder;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerListener.class})
    ProducerListener producerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    @StreamMessageConverter
    @ConditionalOnMissingBean(value={KafkaNullConverter.class})
    MessageConverter kafkaNullConverter() {
        return new KafkaNullConverter();
    }

    @Bean
    @ConditionalOnMissingBean(value={KafkaJaasLoginModuleInitializer.class})
    public KafkaJaasLoginModuleInitializer jaasInitializer(KafkaBinderConfigurationProperties configurationProperties) throws IOException {
        KafkaJaasLoginModuleInitializer kafkaJaasLoginModuleInitializer = new KafkaJaasLoginModuleInitializer();
        JaasLoginModuleConfiguration jaas = configurationProperties.getJaas();
        if (jaas != null) {
            kafkaJaasLoginModuleInitializer.setLoginModule(jaas.getLoginModule());
            KafkaJaasLoginModuleInitializer.ControlFlag controlFlag = jaas.getControlFlag();
            if (controlFlag != null) {
                kafkaJaasLoginModuleInitializer.setControlFlag(controlFlag);
            }
            kafkaJaasLoginModuleInitializer.setOptions(jaas.getOptions());
        }
        return kafkaJaasLoginModuleInitializer;
    }

    public static class JaasConfigurationProperties {
        private JaasLoginModuleConfiguration kafka;
        private JaasLoginModuleConfiguration zookeeper;
    }

    @Configuration
    @ConditionalOnBean(name={"outerContext"})
    @ConditionalOnMissingBean(value={KafkaBinderMetrics.class})
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    protected class KafkaBinderMetricsConfigurationWithMultiBinder {
        protected KafkaBinderMetricsConfigurationWithMultiBinder() {
        }

        @Bean
        public MeterBinder kafkaBinderMetrics(KafkaMessageChannelBinder kafkaMessageChannelBinder, KafkaBinderConfigurationProperties configurationProperties, ConfigurableApplicationContext context) {
            MeterRegistry meterRegistry = (MeterRegistry)((ApplicationContext)context.getBean("outerContext", ApplicationContext.class)).getBean(MeterRegistry.class);
            return new KafkaBinderMetrics(kafkaMessageChannelBinder, configurationProperties, null, meterRegistry);
        }

        @ConditionalOnClass(name={"org.springframework.kafka.core.MicrometerConsumerListener"})
        protected class KafkaMicrometer {
            protected KafkaMicrometer() {
            }

            @Bean
            @ConditionalOnMissingBean(name={"binderClientFactoryCustomizer"})
            public ClientFactoryCustomizer binderClientFactoryCustomizer(final ConfigurableApplicationContext context) {
                return new ClientFactoryCustomizer(){
                    MeterRegistry meterRegistry;
                    {
                        this.meterRegistry = (MeterRegistry)((ApplicationContext)context.getBean("outerContext", ApplicationContext.class)).getBean(MeterRegistry.class);
                    }

                    @Override
                    public void configure(ProducerFactory<?, ?> pf) {
                        if (pf instanceof DefaultKafkaProducerFactory) {
                            ((DefaultKafkaProducerFactory)pf).addListener((ProducerFactory.Listener)new MicrometerProducerListener(this.meterRegistry));
                        }
                    }

                    @Override
                    public void configure(ConsumerFactory<?, ?> cf) {
                        if (cf instanceof DefaultKafkaConsumerFactory) {
                            ((DefaultKafkaConsumerFactory)cf).addListener((ConsumerFactory.Listener)new MicrometerConsumerListener(this.meterRegistry));
                        }
                    }
                };
            }
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={KafkaBinderMetrics.class}, name={"outerContext"})
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    protected class KafkaBinderMetricsConfiguration {
        protected KafkaBinderMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={MeterRegistry.class})
        @ConditionalOnMissingBean(value={KafkaBinderMetrics.class})
        public MeterBinder kafkaBinderMetrics(KafkaMessageChannelBinder kafkaMessageChannelBinder, KafkaBinderConfigurationProperties configurationProperties, MeterRegistry meterRegistry) {
            return new KafkaBinderMetrics(kafkaMessageChannelBinder, configurationProperties, null, meterRegistry);
        }

        @ConditionalOnClass(name={"org.springframework.kafka.core.MicrometerConsumerListener"})
        @ConditionalOnBean(value={MeterRegistry.class})
        protected class KafkaMicrometer {
            protected KafkaMicrometer() {
            }

            @Bean
            @ConditionalOnMissingBean(name={"binderClientFactoryCustomizer"})
            public ClientFactoryCustomizer binderClientFactoryCustomizer(final MeterRegistry meterRegistry) {
                return new ClientFactoryCustomizer(){

                    @Override
                    public void configure(ProducerFactory<?, ?> pf) {
                        if (pf instanceof DefaultKafkaProducerFactory) {
                            ((DefaultKafkaProducerFactory)pf).addListener((ProducerFactory.Listener)new MicrometerProducerListener(meterRegistry));
                        }
                    }

                    @Override
                    public void configure(ConsumerFactory<?, ?> cf) {
                        if (cf instanceof DefaultKafkaConsumerFactory) {
                            ((DefaultKafkaConsumerFactory)cf).addListener((ConsumerFactory.Listener)new MicrometerConsumerListener(meterRegistry));
                        }
                    }
                };
            }
        }
    }
}

