/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsProducerProperties;
import org.springframework.util.StringUtils;

public class KeyValueSerdeResolver {
    private final Map<String, Object> streamConfigGlobalProperties;
    private final KafkaStreamsBinderConfigurationProperties binderConfigurationProperties;

    KeyValueSerdeResolver(Map<String, Object> streamConfigGlobalProperties, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        this.streamConfigGlobalProperties = streamConfigGlobalProperties;
        this.binderConfigurationProperties = binderConfigurationProperties;
    }

    public Serde<?> getInboundKeySerde(KafkaStreamsConsumerProperties extendedConsumerProperties) {
        String keySerdeString = extendedConsumerProperties.getKeySerde();
        return this.getKeySerde(keySerdeString);
    }

    public Serde<?> getInboundValueSerde(ConsumerProperties consumerProperties, KafkaStreamsConsumerProperties extendedConsumerProperties) {
        Serde<?> valueSerde;
        String valueSerdeString = extendedConsumerProperties.getValueSerde();
        try {
            valueSerde = consumerProperties != null && consumerProperties.isUseNativeDecoding() ? this.getValueSerde(valueSerdeString) : Serdes.ByteArray();
            valueSerde.configure(this.streamConfigGlobalProperties, false);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getOuboundKeySerde(KafkaStreamsProducerProperties properties) {
        return this.getKeySerde(properties.getKeySerde());
    }

    public Serde<?> getOutboundValueSerde(ProducerProperties producerProperties, KafkaStreamsProducerProperties kafkaStreamsProducerProperties) {
        Serde<?> valueSerde;
        try {
            valueSerde = producerProperties.isUseNativeEncoding() ? this.getValueSerde(kafkaStreamsProducerProperties.getValueSerde()) : Serdes.ByteArray();
            valueSerde.configure(this.streamConfigGlobalProperties, false);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getStateStoreKeySerde(String keySerdeString) {
        return this.getKeySerde(keySerdeString);
    }

    public Serde<?> getStateStoreValueSerde(String valueSerdeString) {
        try {
            return this.getValueSerde(valueSerdeString);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
    }

    private Serde<?> getKeySerde(String keySerdeString) {
        Serde keySerde;
        try {
            keySerde = StringUtils.hasText((String)keySerdeString) ? (Serde)Utils.newInstance((String)keySerdeString, Serde.class) : (this.binderConfigurationProperties.getConfiguration().containsKey("default.key.serde") ? (Serde)Utils.newInstance((String)((String)this.binderConfigurationProperties.getConfiguration().get("default.key.serde")), Serde.class) : Serdes.ByteArray());
            keySerde.configure(this.streamConfigGlobalProperties, true);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return keySerde;
    }

    private Serde<?> getValueSerde(String valueSerdeString) throws ClassNotFoundException {
        Serde valueSerde = StringUtils.hasText((String)valueSerdeString) ? (Serde)Utils.newInstance((String)valueSerdeString, Serde.class) : (this.binderConfigurationProperties.getConfiguration().containsKey("default.value.serde") ? (Serde)Utils.newInstance((String)((String)this.binderConfigurationProperties.getConfiguration().get("default.value.serde")), Serde.class) : Serdes.ByteArray());
        return valueSerde;
    }
}

